// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53.model



/**
 * Retrieves a list of the public and private hosted zones that are associated with the current Amazon Web Services account in ASCII order by domain name.
 */
class ListHostedZonesByNameRequest private constructor(builder: Builder) {
    /**
     * (Optional) For your first request to `ListHostedZonesByName`, include the `dnsname` parameter only if you want to specify the name of the first hosted zone in the response. If you don't include the `dnsname` parameter, Amazon Route 53 returns all of the hosted zones that were created by the current Amazon Web Services account, in ASCII order. For subsequent requests, include both `dnsname` and `hostedzoneid` parameters. For `dnsname`, specify the value of `NextDNSName` from the previous response.
     */
    val dnsName: kotlin.String? = builder.dnsName
    /**
     * (Optional) For your first request to `ListHostedZonesByName`, do not include the `hostedzoneid` parameter.
     *
     * If you have more hosted zones than the value of `maxitems`, `ListHostedZonesByName` returns only the first `maxitems` hosted zones. To get the next group of `maxitems` hosted zones, submit another request to `ListHostedZonesByName` and include both `dnsname` and `hostedzoneid` parameters. For the value of `hostedzoneid`, specify the value of the `NextHostedZoneId` element from the previous response.
     */
    val hostedZoneId: kotlin.String? = builder.hostedZoneId
    /**
     * The maximum number of hosted zones to be included in the response body for this request. If you have more than `maxitems` hosted zones, then the value of the `IsTruncated` element in the response is true, and the values of `NextDNSName` and `NextHostedZoneId` specify the first hosted zone in the next group of `maxitems` hosted zones.
     */
    val maxItems: kotlin.Int? = builder.maxItems

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53.model.ListHostedZonesByNameRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListHostedZonesByNameRequest(")
        append("dnsName=$dnsName,")
        append("hostedZoneId=$hostedZoneId,")
        append("maxItems=$maxItems)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dnsName?.hashCode() ?: 0
        result = 31 * result + (hostedZoneId?.hashCode() ?: 0)
        result = 31 * result + (maxItems ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListHostedZonesByNameRequest

        if (dnsName != other.dnsName) return false
        if (hostedZoneId != other.hostedZoneId) return false
        if (maxItems != other.maxItems) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53.model.ListHostedZonesByNameRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * (Optional) For your first request to `ListHostedZonesByName`, include the `dnsname` parameter only if you want to specify the name of the first hosted zone in the response. If you don't include the `dnsname` parameter, Amazon Route 53 returns all of the hosted zones that were created by the current Amazon Web Services account, in ASCII order. For subsequent requests, include both `dnsname` and `hostedzoneid` parameters. For `dnsname`, specify the value of `NextDNSName` from the previous response.
         */
        var dnsName: kotlin.String? = null
        /**
         * (Optional) For your first request to `ListHostedZonesByName`, do not include the `hostedzoneid` parameter.
         *
         * If you have more hosted zones than the value of `maxitems`, `ListHostedZonesByName` returns only the first `maxitems` hosted zones. To get the next group of `maxitems` hosted zones, submit another request to `ListHostedZonesByName` and include both `dnsname` and `hostedzoneid` parameters. For the value of `hostedzoneid`, specify the value of the `NextHostedZoneId` element from the previous response.
         */
        var hostedZoneId: kotlin.String? = null
        /**
         * The maximum number of hosted zones to be included in the response body for this request. If you have more than `maxitems` hosted zones, then the value of the `IsTruncated` element in the response is true, and the values of `NextDNSName` and `NextHostedZoneId` specify the first hosted zone in the next group of `maxitems` hosted zones.
         */
        var maxItems: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53.model.ListHostedZonesByNameRequest) : this() {
            this.dnsName = x.dnsName
            this.hostedZoneId = x.hostedZoneId
            this.maxItems = x.maxItems
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53.model.ListHostedZonesByNameRequest = ListHostedZonesByNameRequest(this)
    }
}
