// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53.model



/**
 * A complex type that contains the response information for the request.
 */
class ListHostedZonesByNameResponse private constructor(builder: Builder) {
    /**
     * For the second and subsequent calls to `ListHostedZonesByName`, `DNSName` is the value that you specified for the `dnsname` parameter in the request that produced the current response.
     */
    val dnsName: kotlin.String? = builder.dnsName
    /**
     * The ID that Amazon Route 53 assigned to the hosted zone when you created it.
     */
    val hostedZoneId: kotlin.String? = builder.hostedZoneId
    /**
     * A complex type that contains general information about the hosted zone.
     */
    val hostedZones: List<HostedZone>? = builder.hostedZones
    /**
     * A flag that indicates whether there are more hosted zones to be listed. If the response was truncated, you can get the next group of `maxitems` hosted zones by calling `ListHostedZonesByName` again and specifying the values of `NextDNSName` and `NextHostedZoneId` elements in the `dnsname` and `hostedzoneid` parameters.
     */
    val isTruncated: kotlin.Boolean = builder.isTruncated
    /**
     * The value that you specified for the `maxitems` parameter in the call to `ListHostedZonesByName` that produced the current response.
     */
    val maxItems: kotlin.Int? = builder.maxItems
    /**
     * If `IsTruncated` is true, the value of `NextDNSName` is the name of the first hosted zone in the next group of `maxitems` hosted zones. Call `ListHostedZonesByName` again and specify the value of `NextDNSName` and `NextHostedZoneId` in the `dnsname` and `hostedzoneid` parameters, respectively.
     *
     * This element is present only if `IsTruncated` is `true`.
     */
    val nextDnsName: kotlin.String? = builder.nextDnsName
    /**
     * If `IsTruncated` is `true`, the value of `NextHostedZoneId` identifies the first hosted zone in the next group of `maxitems` hosted zones. Call `ListHostedZonesByName` again and specify the value of `NextDNSName` and `NextHostedZoneId` in the `dnsname` and `hostedzoneid` parameters, respectively.
     *
     * This element is present only if `IsTruncated` is `true`.
     */
    val nextHostedZoneId: kotlin.String? = builder.nextHostedZoneId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53.model.ListHostedZonesByNameResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListHostedZonesByNameResponse(")
        append("dnsName=$dnsName,")
        append("hostedZoneId=$hostedZoneId,")
        append("hostedZones=$hostedZones,")
        append("isTruncated=$isTruncated,")
        append("maxItems=$maxItems,")
        append("nextDnsName=$nextDnsName,")
        append("nextHostedZoneId=$nextHostedZoneId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dnsName?.hashCode() ?: 0
        result = 31 * result + (hostedZoneId?.hashCode() ?: 0)
        result = 31 * result + (hostedZones?.hashCode() ?: 0)
        result = 31 * result + (isTruncated.hashCode())
        result = 31 * result + (maxItems ?: 0)
        result = 31 * result + (nextDnsName?.hashCode() ?: 0)
        result = 31 * result + (nextHostedZoneId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListHostedZonesByNameResponse

        if (dnsName != other.dnsName) return false
        if (hostedZoneId != other.hostedZoneId) return false
        if (hostedZones != other.hostedZones) return false
        if (isTruncated != other.isTruncated) return false
        if (maxItems != other.maxItems) return false
        if (nextDnsName != other.nextDnsName) return false
        if (nextHostedZoneId != other.nextHostedZoneId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53.model.ListHostedZonesByNameResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * For the second and subsequent calls to `ListHostedZonesByName`, `DNSName` is the value that you specified for the `dnsname` parameter in the request that produced the current response.
         */
        var dnsName: kotlin.String? = null
        /**
         * The ID that Amazon Route 53 assigned to the hosted zone when you created it.
         */
        var hostedZoneId: kotlin.String? = null
        /**
         * A complex type that contains general information about the hosted zone.
         */
        var hostedZones: List<HostedZone>? = null
        /**
         * A flag that indicates whether there are more hosted zones to be listed. If the response was truncated, you can get the next group of `maxitems` hosted zones by calling `ListHostedZonesByName` again and specifying the values of `NextDNSName` and `NextHostedZoneId` elements in the `dnsname` and `hostedzoneid` parameters.
         */
        var isTruncated: kotlin.Boolean = false
        /**
         * The value that you specified for the `maxitems` parameter in the call to `ListHostedZonesByName` that produced the current response.
         */
        var maxItems: kotlin.Int? = null
        /**
         * If `IsTruncated` is true, the value of `NextDNSName` is the name of the first hosted zone in the next group of `maxitems` hosted zones. Call `ListHostedZonesByName` again and specify the value of `NextDNSName` and `NextHostedZoneId` in the `dnsname` and `hostedzoneid` parameters, respectively.
         *
         * This element is present only if `IsTruncated` is `true`.
         */
        var nextDnsName: kotlin.String? = null
        /**
         * If `IsTruncated` is `true`, the value of `NextHostedZoneId` identifies the first hosted zone in the next group of `maxitems` hosted zones. Call `ListHostedZonesByName` again and specify the value of `NextDNSName` and `NextHostedZoneId` in the `dnsname` and `hostedzoneid` parameters, respectively.
         *
         * This element is present only if `IsTruncated` is `true`.
         */
        var nextHostedZoneId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53.model.ListHostedZonesByNameResponse) : this() {
            this.dnsName = x.dnsName
            this.hostedZoneId = x.hostedZoneId
            this.hostedZones = x.hostedZones
            this.isTruncated = x.isTruncated
            this.maxItems = x.maxItems
            this.nextDnsName = x.nextDnsName
            this.nextHostedZoneId = x.nextHostedZoneId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53.model.ListHostedZonesByNameResponse = ListHostedZonesByNameResponse(this)
    }
}
