// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53.model



/**
 * Lists all the private hosted zones that a specified VPC is associated with, regardless of which Amazon Web Services account created the hosted zones.
 */
class ListHostedZonesByVpcRequest private constructor(builder: Builder) {
    /**
     * (Optional) The maximum number of hosted zones that you want Amazon Route 53 to return. If the specified VPC is associated with more than `MaxItems` hosted zones, the response includes a `NextToken` element. `NextToken` contains an encrypted token that identifies the first hosted zone that Route 53 will return if you submit another request.
     */
    val maxItems: kotlin.Int? = builder.maxItems
    /**
     * If the previous response included a `NextToken` element, the specified VPC is associated with more hosted zones. To get more hosted zones, submit another `ListHostedZonesByVPC` request.
     *
     * For the value of `NextToken`, specify the value of `NextToken` from the previous response.
     *
     * If the previous response didn't include a `NextToken` element, there are no more hosted zones to get.
     */
    val nextToken: kotlin.String? = builder.nextToken
    /**
     * The ID of the Amazon VPC that you want to list hosted zones for.
     */
    val vpcId: kotlin.String? = builder.vpcId
    /**
     * For the Amazon VPC that you specified for `VPCId`, the Amazon Web Services Region that you created the VPC in.
     */
    val vpcRegion: aws.sdk.kotlin.services.route53.model.VpcRegion? = builder.vpcRegion

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53.model.ListHostedZonesByVpcRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListHostedZonesByVpcRequest(")
        append("maxItems=$maxItems,")
        append("nextToken=$nextToken,")
        append("vpcId=$vpcId,")
        append("vpcRegion=$vpcRegion)")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxItems ?: 0
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        result = 31 * result + (vpcRegion?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListHostedZonesByVpcRequest

        if (maxItems != other.maxItems) return false
        if (nextToken != other.nextToken) return false
        if (vpcId != other.vpcId) return false
        if (vpcRegion != other.vpcRegion) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53.model.ListHostedZonesByVpcRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * (Optional) The maximum number of hosted zones that you want Amazon Route 53 to return. If the specified VPC is associated with more than `MaxItems` hosted zones, the response includes a `NextToken` element. `NextToken` contains an encrypted token that identifies the first hosted zone that Route 53 will return if you submit another request.
         */
        var maxItems: kotlin.Int? = null
        /**
         * If the previous response included a `NextToken` element, the specified VPC is associated with more hosted zones. To get more hosted zones, submit another `ListHostedZonesByVPC` request.
         *
         * For the value of `NextToken`, specify the value of `NextToken` from the previous response.
         *
         * If the previous response didn't include a `NextToken` element, there are no more hosted zones to get.
         */
        var nextToken: kotlin.String? = null
        /**
         * The ID of the Amazon VPC that you want to list hosted zones for.
         */
        var vpcId: kotlin.String? = null
        /**
         * For the Amazon VPC that you specified for `VPCId`, the Amazon Web Services Region that you created the VPC in.
         */
        var vpcRegion: aws.sdk.kotlin.services.route53.model.VpcRegion? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53.model.ListHostedZonesByVpcRequest) : this() {
            this.maxItems = x.maxItems
            this.nextToken = x.nextToken
            this.vpcId = x.vpcId
            this.vpcRegion = x.vpcRegion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53.model.ListHostedZonesByVpcRequest = ListHostedZonesByVpcRequest(this)
    }
}
