// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53.model



/**
 * A request to retrieve a list of the public and private hosted zones that are associated with the current Amazon Web Services account.
 */
class ListHostedZonesRequest private constructor(builder: Builder) {
    /**
     * If you're using reusable delegation sets and you want to list all of the hosted zones that are associated with a reusable delegation set, specify the ID of that reusable delegation set.
     */
    val delegationSetId: kotlin.String? = builder.delegationSetId
    /**
     * If the value of `IsTruncated` in the previous response was `true`, you have more hosted zones. To get more hosted zones, submit another `ListHostedZones` request.
     *
     * For the value of `marker`, specify the value of `NextMarker` from the previous response, which is the ID of the first hosted zone that Amazon Route 53 will return if you submit another request.
     *
     * If the value of `IsTruncated` in the previous response was `false`, there are no more hosted zones to get.
     */
    val marker: kotlin.String? = builder.marker
    /**
     * (Optional) The maximum number of hosted zones that you want Amazon Route 53 to return. If you have more than `maxitems` hosted zones, the value of `IsTruncated` in the response is `true`, and the value of `NextMarker` is the hosted zone ID of the first hosted zone that Route 53 will return if you submit another request.
     */
    val maxItems: kotlin.Int? = builder.maxItems

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53.model.ListHostedZonesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListHostedZonesRequest(")
        append("delegationSetId=$delegationSetId,")
        append("marker=$marker,")
        append("maxItems=$maxItems)")
    }

    override fun hashCode(): kotlin.Int {
        var result = delegationSetId?.hashCode() ?: 0
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxItems ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListHostedZonesRequest

        if (delegationSetId != other.delegationSetId) return false
        if (marker != other.marker) return false
        if (maxItems != other.maxItems) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53.model.ListHostedZonesRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * If you're using reusable delegation sets and you want to list all of the hosted zones that are associated with a reusable delegation set, specify the ID of that reusable delegation set.
         */
        var delegationSetId: kotlin.String? = null
        /**
         * If the value of `IsTruncated` in the previous response was `true`, you have more hosted zones. To get more hosted zones, submit another `ListHostedZones` request.
         *
         * For the value of `marker`, specify the value of `NextMarker` from the previous response, which is the ID of the first hosted zone that Amazon Route 53 will return if you submit another request.
         *
         * If the value of `IsTruncated` in the previous response was `false`, there are no more hosted zones to get.
         */
        var marker: kotlin.String? = null
        /**
         * (Optional) The maximum number of hosted zones that you want Amazon Route 53 to return. If you have more than `maxitems` hosted zones, the value of `IsTruncated` in the response is `true`, and the value of `NextMarker` is the hosted zone ID of the first hosted zone that Route 53 will return if you submit another request.
         */
        var maxItems: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53.model.ListHostedZonesRequest) : this() {
            this.delegationSetId = x.delegationSetId
            this.marker = x.marker
            this.maxItems = x.maxItems
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53.model.ListHostedZonesRequest = ListHostedZonesRequest(this)
    }
}
