// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53.model



class ListQueryLoggingConfigsRequest private constructor(builder: Builder) {
    /**
     * (Optional) If you want to list the query logging configuration that is associated with a hosted zone, specify the ID in `HostedZoneId`.
     *
     * If you don't specify a hosted zone ID, `ListQueryLoggingConfigs` returns all of the configurations that are associated with the current Amazon Web Services account.
     */
    val hostedZoneId: kotlin.String? = builder.hostedZoneId
    /**
     * (Optional) The maximum number of query logging configurations that you want Amazon Route 53 to return in response to the current request. If the current Amazon Web Services account has more than `MaxResults` configurations, use the value of [NextToken](https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListQueryLoggingConfigs.html#API_ListQueryLoggingConfigs_RequestSyntax) in the response to get the next page of results.
     *
     * If you don't specify a value for `MaxResults`, Route 53 returns up to 100 configurations.
     */
    val maxResults: kotlin.Int? = builder.maxResults
    /**
     * (Optional) If the current Amazon Web Services account has more than `MaxResults` query logging configurations, use `NextToken` to get the second and subsequent pages of results.
     *
     * For the first `ListQueryLoggingConfigs` request, omit this value.
     *
     * For the second and subsequent requests, get the value of `NextToken` from the previous response and specify that value for `NextToken` in the request.
     */
    val nextToken: kotlin.String? = builder.nextToken

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53.model.ListQueryLoggingConfigsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListQueryLoggingConfigsRequest(")
        append("hostedZoneId=$hostedZoneId,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = hostedZoneId?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListQueryLoggingConfigsRequest

        if (hostedZoneId != other.hostedZoneId) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53.model.ListQueryLoggingConfigsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * (Optional) If you want to list the query logging configuration that is associated with a hosted zone, specify the ID in `HostedZoneId`.
         *
         * If you don't specify a hosted zone ID, `ListQueryLoggingConfigs` returns all of the configurations that are associated with the current Amazon Web Services account.
         */
        var hostedZoneId: kotlin.String? = null
        /**
         * (Optional) The maximum number of query logging configurations that you want Amazon Route 53 to return in response to the current request. If the current Amazon Web Services account has more than `MaxResults` configurations, use the value of [NextToken](https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListQueryLoggingConfigs.html#API_ListQueryLoggingConfigs_RequestSyntax) in the response to get the next page of results.
         *
         * If you don't specify a value for `MaxResults`, Route 53 returns up to 100 configurations.
         */
        var maxResults: kotlin.Int? = null
        /**
         * (Optional) If the current Amazon Web Services account has more than `MaxResults` query logging configurations, use `NextToken` to get the second and subsequent pages of results.
         *
         * For the first `ListQueryLoggingConfigs` request, omit this value.
         *
         * For the second and subsequent requests, get the value of `NextToken` from the previous response and specify that value for `NextToken` in the request.
         */
        var nextToken: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53.model.ListQueryLoggingConfigsRequest) : this() {
            this.hostedZoneId = x.hostedZoneId
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53.model.ListQueryLoggingConfigsRequest = ListQueryLoggingConfigsRequest(this)
    }
}
