// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53.model



/**
 * A request for the resource record sets that are associated with a specified hosted zone.
 */
class ListResourceRecordSetsRequest private constructor(builder: Builder) {
    /**
     * The ID of the hosted zone that contains the resource record sets that you want to list.
     */
    val hostedZoneId: kotlin.String? = requireNotNull(builder.hostedZoneId) { "A non-null value must be provided for hostedZoneId" }
    /**
     * (Optional) The maximum number of resource records sets to include in the response body for this request. If the response includes more than `maxitems` resource record sets, the value of the `IsTruncated` element in the response is `true`, and the values of the `NextRecordName` and `NextRecordType` elements in the response identify the first resource record set in the next group of `maxitems` resource record sets.
     */
    val maxItems: kotlin.Int? = builder.maxItems
    /**
     * *Resource record sets that have a routing policy other than simple:* If results were truncated for a given DNS name and type, specify the value of `NextRecordIdentifier` from the previous response to get the next resource record set that has the current DNS name and type.
     */
    val startRecordIdentifier: kotlin.String? = builder.startRecordIdentifier
    /**
     * The first name in the lexicographic ordering of resource record sets that you want to list. If the specified record name doesn't exist, the results begin with the first resource record set that has a name greater than the value of `name`.
     */
    val startRecordName: kotlin.String? = builder.startRecordName
    /**
     * The type of resource record set to begin the record listing from.
     *
     * Valid values for basic resource record sets: `A` | `AAAA` | `CAA` | `CNAME` | `MX` | `NAPTR` | `NS` | `PTR` | `SOA` | `SPF` | `SRV` | `TXT`
     *
     * Values for weighted, latency, geolocation, and failover resource record sets: `A` | `AAAA` | `CAA` | `CNAME` | `MX` | `NAPTR` | `PTR` | `SPF` | `SRV` | `TXT`
     *
     * Values for alias resource record sets:
     * + **API Gateway custom regional API or edge-optimized API**: A
     * + **CloudFront distribution**: A or AAAA
     * + **Elastic Beanstalk environment that has a regionalized subdomain**: A
     * + **Elastic Load Balancing load balancer**: A | AAAA
     * + **S3 bucket**: A
     * + **VPC interface VPC endpoint**: A
     * + **Another resource record set in this hosted zone:** The type of the resource record set that the alias references.
     *
     * Constraint: Specifying `type` without specifying `name` returns an `InvalidInput` error.
     */
    val startRecordType: aws.sdk.kotlin.services.route53.model.RrType? = builder.startRecordType

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53.model.ListResourceRecordSetsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListResourceRecordSetsRequest(")
        append("hostedZoneId=$hostedZoneId,")
        append("maxItems=$maxItems,")
        append("startRecordIdentifier=$startRecordIdentifier,")
        append("startRecordName=$startRecordName,")
        append("startRecordType=$startRecordType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = hostedZoneId?.hashCode() ?: 0
        result = 31 * result + (maxItems ?: 0)
        result = 31 * result + (startRecordIdentifier?.hashCode() ?: 0)
        result = 31 * result + (startRecordName?.hashCode() ?: 0)
        result = 31 * result + (startRecordType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListResourceRecordSetsRequest

        if (hostedZoneId != other.hostedZoneId) return false
        if (maxItems != other.maxItems) return false
        if (startRecordIdentifier != other.startRecordIdentifier) return false
        if (startRecordName != other.startRecordName) return false
        if (startRecordType != other.startRecordType) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53.model.ListResourceRecordSetsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The ID of the hosted zone that contains the resource record sets that you want to list.
         */
        var hostedZoneId: kotlin.String? = null
        /**
         * (Optional) The maximum number of resource records sets to include in the response body for this request. If the response includes more than `maxitems` resource record sets, the value of the `IsTruncated` element in the response is `true`, and the values of the `NextRecordName` and `NextRecordType` elements in the response identify the first resource record set in the next group of `maxitems` resource record sets.
         */
        var maxItems: kotlin.Int? = null
        /**
         * *Resource record sets that have a routing policy other than simple:* If results were truncated for a given DNS name and type, specify the value of `NextRecordIdentifier` from the previous response to get the next resource record set that has the current DNS name and type.
         */
        var startRecordIdentifier: kotlin.String? = null
        /**
         * The first name in the lexicographic ordering of resource record sets that you want to list. If the specified record name doesn't exist, the results begin with the first resource record set that has a name greater than the value of `name`.
         */
        var startRecordName: kotlin.String? = null
        /**
         * The type of resource record set to begin the record listing from.
         *
         * Valid values for basic resource record sets: `A` | `AAAA` | `CAA` | `CNAME` | `MX` | `NAPTR` | `NS` | `PTR` | `SOA` | `SPF` | `SRV` | `TXT`
         *
         * Values for weighted, latency, geolocation, and failover resource record sets: `A` | `AAAA` | `CAA` | `CNAME` | `MX` | `NAPTR` | `PTR` | `SPF` | `SRV` | `TXT`
         *
         * Values for alias resource record sets:
         * + **API Gateway custom regional API or edge-optimized API**: A
         * + **CloudFront distribution**: A or AAAA
         * + **Elastic Beanstalk environment that has a regionalized subdomain**: A
         * + **Elastic Load Balancing load balancer**: A | AAAA
         * + **S3 bucket**: A
         * + **VPC interface VPC endpoint**: A
         * + **Another resource record set in this hosted zone:** The type of the resource record set that the alias references.
         *
         * Constraint: Specifying `type` without specifying `name` returns an `InvalidInput` error.
         */
        var startRecordType: aws.sdk.kotlin.services.route53.model.RrType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53.model.ListResourceRecordSetsRequest) : this() {
            this.hostedZoneId = x.hostedZoneId
            this.maxItems = x.maxItems
            this.startRecordIdentifier = x.startRecordIdentifier
            this.startRecordName = x.startRecordName
            this.startRecordType = x.startRecordType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53.model.ListResourceRecordSetsRequest = ListResourceRecordSetsRequest(this)
    }
}
