// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53.model



/**
 * A complex type that contains list information for the resource record set.
 */
class ListResourceRecordSetsResponse private constructor(builder: Builder) {
    /**
     * A flag that indicates whether more resource record sets remain to be listed. If your results were truncated, you can make a follow-up pagination request by using the `NextRecordName` element.
     */
    val isTruncated: kotlin.Boolean = builder.isTruncated
    /**
     * The maximum number of records you requested.
     */
    val maxItems: kotlin.Int? = builder.maxItems
    /**
     * *Resource record sets that have a routing policy other than simple:* If results were truncated for a given DNS name and type, the value of `SetIdentifier` for the next resource record set that has the current DNS name and type.
     *
     * For information about routing policies, see [Choosing a Routing Policy](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html) in the *Amazon Route 53 Developer Guide*.
     */
    val nextRecordIdentifier: kotlin.String? = builder.nextRecordIdentifier
    /**
     * If the results were truncated, the name of the next record in the list.
     *
     * This element is present only if `IsTruncated` is true.
     */
    val nextRecordName: kotlin.String? = builder.nextRecordName
    /**
     * If the results were truncated, the type of the next record in the list.
     *
     * This element is present only if `IsTruncated` is true.
     */
    val nextRecordType: aws.sdk.kotlin.services.route53.model.RrType? = builder.nextRecordType
    /**
     * Information about multiple resource record sets.
     */
    val resourceRecordSets: List<ResourceRecordSet>? = builder.resourceRecordSets

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53.model.ListResourceRecordSetsResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListResourceRecordSetsResponse(")
        append("isTruncated=$isTruncated,")
        append("maxItems=$maxItems,")
        append("nextRecordIdentifier=$nextRecordIdentifier,")
        append("nextRecordName=$nextRecordName,")
        append("nextRecordType=$nextRecordType,")
        append("resourceRecordSets=$resourceRecordSets)")
    }

    override fun hashCode(): kotlin.Int {
        var result = isTruncated.hashCode()
        result = 31 * result + (maxItems ?: 0)
        result = 31 * result + (nextRecordIdentifier?.hashCode() ?: 0)
        result = 31 * result + (nextRecordName?.hashCode() ?: 0)
        result = 31 * result + (nextRecordType?.hashCode() ?: 0)
        result = 31 * result + (resourceRecordSets?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListResourceRecordSetsResponse

        if (isTruncated != other.isTruncated) return false
        if (maxItems != other.maxItems) return false
        if (nextRecordIdentifier != other.nextRecordIdentifier) return false
        if (nextRecordName != other.nextRecordName) return false
        if (nextRecordType != other.nextRecordType) return false
        if (resourceRecordSets != other.resourceRecordSets) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53.model.ListResourceRecordSetsResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * A flag that indicates whether more resource record sets remain to be listed. If your results were truncated, you can make a follow-up pagination request by using the `NextRecordName` element.
         */
        var isTruncated: kotlin.Boolean = false
        /**
         * The maximum number of records you requested.
         */
        var maxItems: kotlin.Int? = null
        /**
         * *Resource record sets that have a routing policy other than simple:* If results were truncated for a given DNS name and type, the value of `SetIdentifier` for the next resource record set that has the current DNS name and type.
         *
         * For information about routing policies, see [Choosing a Routing Policy](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html) in the *Amazon Route 53 Developer Guide*.
         */
        var nextRecordIdentifier: kotlin.String? = null
        /**
         * If the results were truncated, the name of the next record in the list.
         *
         * This element is present only if `IsTruncated` is true.
         */
        var nextRecordName: kotlin.String? = null
        /**
         * If the results were truncated, the type of the next record in the list.
         *
         * This element is present only if `IsTruncated` is true.
         */
        var nextRecordType: aws.sdk.kotlin.services.route53.model.RrType? = null
        /**
         * Information about multiple resource record sets.
         */
        var resourceRecordSets: List<ResourceRecordSet>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53.model.ListResourceRecordSetsResponse) : this() {
            this.isTruncated = x.isTruncated
            this.maxItems = x.maxItems
            this.nextRecordIdentifier = x.nextRecordIdentifier
            this.nextRecordName = x.nextRecordName
            this.nextRecordType = x.nextRecordType
            this.resourceRecordSets = x.resourceRecordSets
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53.model.ListResourceRecordSetsResponse = ListResourceRecordSetsResponse(this)
    }
}
