// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53.model



/**
 * A request to get a list of the reusable delegation sets that are associated with the current Amazon Web Services account.
 */
class ListReusableDelegationSetsRequest private constructor(builder: Builder) {
    /**
     * If the value of `IsTruncated` in the previous response was `true`, you have more reusable delegation sets. To get another group, submit another `ListReusableDelegationSets` request.
     *
     * For the value of `marker`, specify the value of `NextMarker` from the previous response, which is the ID of the first reusable delegation set that Amazon Route 53 will return if you submit another request.
     *
     * If the value of `IsTruncated` in the previous response was `false`, there are no more reusable delegation sets to get.
     */
    val marker: kotlin.String? = builder.marker
    /**
     * The number of reusable delegation sets that you want Amazon Route 53 to return in the response to this request. If you specify a value greater than 100, Route 53 returns only the first 100 reusable delegation sets.
     */
    val maxItems: kotlin.Int? = builder.maxItems

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53.model.ListReusableDelegationSetsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListReusableDelegationSetsRequest(")
        append("marker=$marker,")
        append("maxItems=$maxItems)")
    }

    override fun hashCode(): kotlin.Int {
        var result = marker?.hashCode() ?: 0
        result = 31 * result + (maxItems ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListReusableDelegationSetsRequest

        if (marker != other.marker) return false
        if (maxItems != other.maxItems) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53.model.ListReusableDelegationSetsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * If the value of `IsTruncated` in the previous response was `true`, you have more reusable delegation sets. To get another group, submit another `ListReusableDelegationSets` request.
         *
         * For the value of `marker`, specify the value of `NextMarker` from the previous response, which is the ID of the first reusable delegation set that Amazon Route 53 will return if you submit another request.
         *
         * If the value of `IsTruncated` in the previous response was `false`, there are no more reusable delegation sets to get.
         */
        var marker: kotlin.String? = null
        /**
         * The number of reusable delegation sets that you want Amazon Route 53 to return in the response to this request. If you specify a value greater than 100, Route 53 returns only the first 100 reusable delegation sets.
         */
        var maxItems: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53.model.ListReusableDelegationSetsRequest) : this() {
            this.marker = x.marker
            this.maxItems = x.maxItems
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53.model.ListReusableDelegationSetsRequest = ListReusableDelegationSetsRequest(this)
    }
}
