// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53.model



/**
 * A complex type that contains information about the reusable delegation sets that are associated with the current Amazon Web Services account.
 */
class ListReusableDelegationSetsResponse private constructor(builder: Builder) {
    /**
     * A complex type that contains one `DelegationSet` element for each reusable delegation set that was created by the current Amazon Web Services account.
     */
    val delegationSets: List<DelegationSet>? = builder.delegationSets
    /**
     * A flag that indicates whether there are more reusable delegation sets to be listed.
     */
    val isTruncated: kotlin.Boolean = builder.isTruncated
    /**
     * For the second and subsequent calls to `ListReusableDelegationSets`, `Marker` is the value that you specified for the `marker` parameter in the request that produced the current response.
     */
    val marker: kotlin.String? = builder.marker
    /**
     * The value that you specified for the `maxitems` parameter in the call to `ListReusableDelegationSets` that produced the current response.
     */
    val maxItems: kotlin.Int? = builder.maxItems
    /**
     * If `IsTruncated` is `true`, the value of `NextMarker` identifies the next reusable delegation set that Amazon Route 53 will return if you submit another `ListReusableDelegationSets` request and specify the value of `NextMarker` in the `marker` parameter.
     */
    val nextMarker: kotlin.String? = builder.nextMarker

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53.model.ListReusableDelegationSetsResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListReusableDelegationSetsResponse(")
        append("delegationSets=$delegationSets,")
        append("isTruncated=$isTruncated,")
        append("marker=$marker,")
        append("maxItems=$maxItems,")
        append("nextMarker=$nextMarker)")
    }

    override fun hashCode(): kotlin.Int {
        var result = delegationSets?.hashCode() ?: 0
        result = 31 * result + (isTruncated.hashCode())
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxItems ?: 0)
        result = 31 * result + (nextMarker?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListReusableDelegationSetsResponse

        if (delegationSets != other.delegationSets) return false
        if (isTruncated != other.isTruncated) return false
        if (marker != other.marker) return false
        if (maxItems != other.maxItems) return false
        if (nextMarker != other.nextMarker) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53.model.ListReusableDelegationSetsResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * A complex type that contains one `DelegationSet` element for each reusable delegation set that was created by the current Amazon Web Services account.
         */
        var delegationSets: List<DelegationSet>? = null
        /**
         * A flag that indicates whether there are more reusable delegation sets to be listed.
         */
        var isTruncated: kotlin.Boolean = false
        /**
         * For the second and subsequent calls to `ListReusableDelegationSets`, `Marker` is the value that you specified for the `marker` parameter in the request that produced the current response.
         */
        var marker: kotlin.String? = null
        /**
         * The value that you specified for the `maxitems` parameter in the call to `ListReusableDelegationSets` that produced the current response.
         */
        var maxItems: kotlin.Int? = null
        /**
         * If `IsTruncated` is `true`, the value of `NextMarker` identifies the next reusable delegation set that Amazon Route 53 will return if you submit another `ListReusableDelegationSets` request and specify the value of `NextMarker` in the `marker` parameter.
         */
        var nextMarker: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53.model.ListReusableDelegationSetsResponse) : this() {
            this.delegationSets = x.delegationSets
            this.isTruncated = x.isTruncated
            this.marker = x.marker
            this.maxItems = x.maxItems
            this.nextMarker = x.nextMarker
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53.model.ListReusableDelegationSetsResponse = ListReusableDelegationSetsResponse(this)
    }
}
