// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53.model



/**
 * A request for the traffic policy instances that you created in a specified hosted zone.
 */
class ListTrafficPolicyInstancesByHostedZoneRequest private constructor(builder: Builder) {
    /**
     * The ID of the hosted zone that you want to list traffic policy instances for.
     */
    val hostedZoneId: kotlin.String? = builder.hostedZoneId
    /**
     * The maximum number of traffic policy instances to be included in the response body for this request. If you have more than `MaxItems` traffic policy instances, the value of the `IsTruncated` element in the response is `true`, and the values of `HostedZoneIdMarker`, `TrafficPolicyInstanceNameMarker`, and `TrafficPolicyInstanceTypeMarker` represent the first traffic policy instance that Amazon Route 53 will return if you submit another request.
     */
    val maxItems: kotlin.Int? = builder.maxItems
    /**
     * If the value of `IsTruncated` in the previous response is true, you have more traffic policy instances. To get more traffic policy instances, submit another `ListTrafficPolicyInstances` request. For the value of `trafficpolicyinstancename`, specify the value of `TrafficPolicyInstanceNameMarker` from the previous response, which is the name of the first traffic policy instance in the next group of traffic policy instances.
     *
     * If the value of `IsTruncated` in the previous response was `false`, there are no more traffic policy instances to get.
     */
    val trafficPolicyInstanceNameMarker: kotlin.String? = builder.trafficPolicyInstanceNameMarker
    /**
     * If the value of `IsTruncated` in the previous response is true, you have more traffic policy instances. To get more traffic policy instances, submit another `ListTrafficPolicyInstances` request. For the value of `trafficpolicyinstancetype`, specify the value of `TrafficPolicyInstanceTypeMarker` from the previous response, which is the type of the first traffic policy instance in the next group of traffic policy instances.
     *
     * If the value of `IsTruncated` in the previous response was `false`, there are no more traffic policy instances to get.
     */
    val trafficPolicyInstanceTypeMarker: aws.sdk.kotlin.services.route53.model.RrType? = builder.trafficPolicyInstanceTypeMarker

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53.model.ListTrafficPolicyInstancesByHostedZoneRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListTrafficPolicyInstancesByHostedZoneRequest(")
        append("hostedZoneId=$hostedZoneId,")
        append("maxItems=$maxItems,")
        append("trafficPolicyInstanceNameMarker=$trafficPolicyInstanceNameMarker,")
        append("trafficPolicyInstanceTypeMarker=$trafficPolicyInstanceTypeMarker)")
    }

    override fun hashCode(): kotlin.Int {
        var result = hostedZoneId?.hashCode() ?: 0
        result = 31 * result + (maxItems ?: 0)
        result = 31 * result + (trafficPolicyInstanceNameMarker?.hashCode() ?: 0)
        result = 31 * result + (trafficPolicyInstanceTypeMarker?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListTrafficPolicyInstancesByHostedZoneRequest

        if (hostedZoneId != other.hostedZoneId) return false
        if (maxItems != other.maxItems) return false
        if (trafficPolicyInstanceNameMarker != other.trafficPolicyInstanceNameMarker) return false
        if (trafficPolicyInstanceTypeMarker != other.trafficPolicyInstanceTypeMarker) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53.model.ListTrafficPolicyInstancesByHostedZoneRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The ID of the hosted zone that you want to list traffic policy instances for.
         */
        var hostedZoneId: kotlin.String? = null
        /**
         * The maximum number of traffic policy instances to be included in the response body for this request. If you have more than `MaxItems` traffic policy instances, the value of the `IsTruncated` element in the response is `true`, and the values of `HostedZoneIdMarker`, `TrafficPolicyInstanceNameMarker`, and `TrafficPolicyInstanceTypeMarker` represent the first traffic policy instance that Amazon Route 53 will return if you submit another request.
         */
        var maxItems: kotlin.Int? = null
        /**
         * If the value of `IsTruncated` in the previous response is true, you have more traffic policy instances. To get more traffic policy instances, submit another `ListTrafficPolicyInstances` request. For the value of `trafficpolicyinstancename`, specify the value of `TrafficPolicyInstanceNameMarker` from the previous response, which is the name of the first traffic policy instance in the next group of traffic policy instances.
         *
         * If the value of `IsTruncated` in the previous response was `false`, there are no more traffic policy instances to get.
         */
        var trafficPolicyInstanceNameMarker: kotlin.String? = null
        /**
         * If the value of `IsTruncated` in the previous response is true, you have more traffic policy instances. To get more traffic policy instances, submit another `ListTrafficPolicyInstances` request. For the value of `trafficpolicyinstancetype`, specify the value of `TrafficPolicyInstanceTypeMarker` from the previous response, which is the type of the first traffic policy instance in the next group of traffic policy instances.
         *
         * If the value of `IsTruncated` in the previous response was `false`, there are no more traffic policy instances to get.
         */
        var trafficPolicyInstanceTypeMarker: aws.sdk.kotlin.services.route53.model.RrType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53.model.ListTrafficPolicyInstancesByHostedZoneRequest) : this() {
            this.hostedZoneId = x.hostedZoneId
            this.maxItems = x.maxItems
            this.trafficPolicyInstanceNameMarker = x.trafficPolicyInstanceNameMarker
            this.trafficPolicyInstanceTypeMarker = x.trafficPolicyInstanceTypeMarker
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53.model.ListTrafficPolicyInstancesByHostedZoneRequest = ListTrafficPolicyInstancesByHostedZoneRequest(this)
    }
}
