// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53.model



/**
 * A complex type that contains the response information for the request.
 */
class ListTrafficPolicyInstancesByHostedZoneResponse private constructor(builder: Builder) {
    /**
     * A flag that indicates whether there are more traffic policy instances to be listed. If the response was truncated, you can get the next group of traffic policy instances by submitting another `ListTrafficPolicyInstancesByHostedZone` request and specifying the values of `HostedZoneIdMarker`, `TrafficPolicyInstanceNameMarker`, and `TrafficPolicyInstanceTypeMarker` in the corresponding request parameters.
     */
    val isTruncated: kotlin.Boolean = builder.isTruncated
    /**
     * The value that you specified for the `MaxItems` parameter in the `ListTrafficPolicyInstancesByHostedZone` request that produced the current response.
     */
    val maxItems: kotlin.Int? = builder.maxItems
    /**
     * If `IsTruncated` is `true`, `TrafficPolicyInstanceNameMarker` is the name of the first traffic policy instance in the next group of traffic policy instances.
     */
    val trafficPolicyInstanceNameMarker: kotlin.String? = builder.trafficPolicyInstanceNameMarker
    /**
     * If `IsTruncated` is true, `TrafficPolicyInstanceTypeMarker` is the DNS type of the resource record sets that are associated with the first traffic policy instance in the next group of traffic policy instances.
     */
    val trafficPolicyInstanceTypeMarker: aws.sdk.kotlin.services.route53.model.RrType? = builder.trafficPolicyInstanceTypeMarker
    /**
     * A list that contains one `TrafficPolicyInstance` element for each traffic policy instance that matches the elements in the request.
     */
    val trafficPolicyInstances: List<TrafficPolicyInstance>? = builder.trafficPolicyInstances

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53.model.ListTrafficPolicyInstancesByHostedZoneResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListTrafficPolicyInstancesByHostedZoneResponse(")
        append("isTruncated=$isTruncated,")
        append("maxItems=$maxItems,")
        append("trafficPolicyInstanceNameMarker=$trafficPolicyInstanceNameMarker,")
        append("trafficPolicyInstanceTypeMarker=$trafficPolicyInstanceTypeMarker,")
        append("trafficPolicyInstances=$trafficPolicyInstances)")
    }

    override fun hashCode(): kotlin.Int {
        var result = isTruncated.hashCode()
        result = 31 * result + (maxItems ?: 0)
        result = 31 * result + (trafficPolicyInstanceNameMarker?.hashCode() ?: 0)
        result = 31 * result + (trafficPolicyInstanceTypeMarker?.hashCode() ?: 0)
        result = 31 * result + (trafficPolicyInstances?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListTrafficPolicyInstancesByHostedZoneResponse

        if (isTruncated != other.isTruncated) return false
        if (maxItems != other.maxItems) return false
        if (trafficPolicyInstanceNameMarker != other.trafficPolicyInstanceNameMarker) return false
        if (trafficPolicyInstanceTypeMarker != other.trafficPolicyInstanceTypeMarker) return false
        if (trafficPolicyInstances != other.trafficPolicyInstances) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53.model.ListTrafficPolicyInstancesByHostedZoneResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * A flag that indicates whether there are more traffic policy instances to be listed. If the response was truncated, you can get the next group of traffic policy instances by submitting another `ListTrafficPolicyInstancesByHostedZone` request and specifying the values of `HostedZoneIdMarker`, `TrafficPolicyInstanceNameMarker`, and `TrafficPolicyInstanceTypeMarker` in the corresponding request parameters.
         */
        var isTruncated: kotlin.Boolean = false
        /**
         * The value that you specified for the `MaxItems` parameter in the `ListTrafficPolicyInstancesByHostedZone` request that produced the current response.
         */
        var maxItems: kotlin.Int? = null
        /**
         * If `IsTruncated` is `true`, `TrafficPolicyInstanceNameMarker` is the name of the first traffic policy instance in the next group of traffic policy instances.
         */
        var trafficPolicyInstanceNameMarker: kotlin.String? = null
        /**
         * If `IsTruncated` is true, `TrafficPolicyInstanceTypeMarker` is the DNS type of the resource record sets that are associated with the first traffic policy instance in the next group of traffic policy instances.
         */
        var trafficPolicyInstanceTypeMarker: aws.sdk.kotlin.services.route53.model.RrType? = null
        /**
         * A list that contains one `TrafficPolicyInstance` element for each traffic policy instance that matches the elements in the request.
         */
        var trafficPolicyInstances: List<TrafficPolicyInstance>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53.model.ListTrafficPolicyInstancesByHostedZoneResponse) : this() {
            this.isTruncated = x.isTruncated
            this.maxItems = x.maxItems
            this.trafficPolicyInstanceNameMarker = x.trafficPolicyInstanceNameMarker
            this.trafficPolicyInstanceTypeMarker = x.trafficPolicyInstanceTypeMarker
            this.trafficPolicyInstances = x.trafficPolicyInstances
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53.model.ListTrafficPolicyInstancesByHostedZoneResponse = ListTrafficPolicyInstancesByHostedZoneResponse(this)
    }
}
