// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53.model



/**
 * A request to get information about the traffic policy instances that you created by using the current Amazon Web Services account.
 */
class ListTrafficPolicyInstancesRequest private constructor(builder: Builder) {
    /**
     * If the value of `IsTruncated` in the previous response was `true`, you have more traffic policy instances. To get more traffic policy instances, submit another `ListTrafficPolicyInstances` request. For the value of `HostedZoneId`, specify the value of `HostedZoneIdMarker` from the previous response, which is the hosted zone ID of the first traffic policy instance in the next group of traffic policy instances.
     *
     * If the value of `IsTruncated` in the previous response was `false`, there are no more traffic policy instances to get.
     */
    val hostedZoneIdMarker: kotlin.String? = builder.hostedZoneIdMarker
    /**
     * The maximum number of traffic policy instances that you want Amazon Route 53 to return in response to a `ListTrafficPolicyInstances` request. If you have more than `MaxItems` traffic policy instances, the value of the `IsTruncated` element in the response is `true`, and the values of `HostedZoneIdMarker`, `TrafficPolicyInstanceNameMarker`, and `TrafficPolicyInstanceTypeMarker` represent the first traffic policy instance in the next group of `MaxItems` traffic policy instances.
     */
    val maxItems: kotlin.Int? = builder.maxItems
    /**
     * If the value of `IsTruncated` in the previous response was `true`, you have more traffic policy instances. To get more traffic policy instances, submit another `ListTrafficPolicyInstances` request. For the value of `trafficpolicyinstancename`, specify the value of `TrafficPolicyInstanceNameMarker` from the previous response, which is the name of the first traffic policy instance in the next group of traffic policy instances.
     *
     * If the value of `IsTruncated` in the previous response was `false`, there are no more traffic policy instances to get.
     */
    val trafficPolicyInstanceNameMarker: kotlin.String? = builder.trafficPolicyInstanceNameMarker
    /**
     * If the value of `IsTruncated` in the previous response was `true`, you have more traffic policy instances. To get more traffic policy instances, submit another `ListTrafficPolicyInstances` request. For the value of `trafficpolicyinstancetype`, specify the value of `TrafficPolicyInstanceTypeMarker` from the previous response, which is the type of the first traffic policy instance in the next group of traffic policy instances.
     *
     * If the value of `IsTruncated` in the previous response was `false`, there are no more traffic policy instances to get.
     */
    val trafficPolicyInstanceTypeMarker: aws.sdk.kotlin.services.route53.model.RrType? = builder.trafficPolicyInstanceTypeMarker

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53.model.ListTrafficPolicyInstancesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListTrafficPolicyInstancesRequest(")
        append("hostedZoneIdMarker=$hostedZoneIdMarker,")
        append("maxItems=$maxItems,")
        append("trafficPolicyInstanceNameMarker=$trafficPolicyInstanceNameMarker,")
        append("trafficPolicyInstanceTypeMarker=$trafficPolicyInstanceTypeMarker)")
    }

    override fun hashCode(): kotlin.Int {
        var result = hostedZoneIdMarker?.hashCode() ?: 0
        result = 31 * result + (maxItems ?: 0)
        result = 31 * result + (trafficPolicyInstanceNameMarker?.hashCode() ?: 0)
        result = 31 * result + (trafficPolicyInstanceTypeMarker?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListTrafficPolicyInstancesRequest

        if (hostedZoneIdMarker != other.hostedZoneIdMarker) return false
        if (maxItems != other.maxItems) return false
        if (trafficPolicyInstanceNameMarker != other.trafficPolicyInstanceNameMarker) return false
        if (trafficPolicyInstanceTypeMarker != other.trafficPolicyInstanceTypeMarker) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53.model.ListTrafficPolicyInstancesRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * If the value of `IsTruncated` in the previous response was `true`, you have more traffic policy instances. To get more traffic policy instances, submit another `ListTrafficPolicyInstances` request. For the value of `HostedZoneId`, specify the value of `HostedZoneIdMarker` from the previous response, which is the hosted zone ID of the first traffic policy instance in the next group of traffic policy instances.
         *
         * If the value of `IsTruncated` in the previous response was `false`, there are no more traffic policy instances to get.
         */
        var hostedZoneIdMarker: kotlin.String? = null
        /**
         * The maximum number of traffic policy instances that you want Amazon Route 53 to return in response to a `ListTrafficPolicyInstances` request. If you have more than `MaxItems` traffic policy instances, the value of the `IsTruncated` element in the response is `true`, and the values of `HostedZoneIdMarker`, `TrafficPolicyInstanceNameMarker`, and `TrafficPolicyInstanceTypeMarker` represent the first traffic policy instance in the next group of `MaxItems` traffic policy instances.
         */
        var maxItems: kotlin.Int? = null
        /**
         * If the value of `IsTruncated` in the previous response was `true`, you have more traffic policy instances. To get more traffic policy instances, submit another `ListTrafficPolicyInstances` request. For the value of `trafficpolicyinstancename`, specify the value of `TrafficPolicyInstanceNameMarker` from the previous response, which is the name of the first traffic policy instance in the next group of traffic policy instances.
         *
         * If the value of `IsTruncated` in the previous response was `false`, there are no more traffic policy instances to get.
         */
        var trafficPolicyInstanceNameMarker: kotlin.String? = null
        /**
         * If the value of `IsTruncated` in the previous response was `true`, you have more traffic policy instances. To get more traffic policy instances, submit another `ListTrafficPolicyInstances` request. For the value of `trafficpolicyinstancetype`, specify the value of `TrafficPolicyInstanceTypeMarker` from the previous response, which is the type of the first traffic policy instance in the next group of traffic policy instances.
         *
         * If the value of `IsTruncated` in the previous response was `false`, there are no more traffic policy instances to get.
         */
        var trafficPolicyInstanceTypeMarker: aws.sdk.kotlin.services.route53.model.RrType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53.model.ListTrafficPolicyInstancesRequest) : this() {
            this.hostedZoneIdMarker = x.hostedZoneIdMarker
            this.maxItems = x.maxItems
            this.trafficPolicyInstanceNameMarker = x.trafficPolicyInstanceNameMarker
            this.trafficPolicyInstanceTypeMarker = x.trafficPolicyInstanceTypeMarker
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53.model.ListTrafficPolicyInstancesRequest = ListTrafficPolicyInstancesRequest(this)
    }
}
