// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53.model



/**
 * A complex type that contains the response information for the request.
 */
class ListTrafficPolicyVersionsResponse private constructor(builder: Builder) {
    /**
     * A flag that indicates whether there are more traffic policies to be listed. If the response was truncated, you can get the next group of traffic policies by submitting another `ListTrafficPolicyVersions` request and specifying the value of `NextMarker` in the `marker` parameter.
     */
    val isTruncated: kotlin.Boolean = builder.isTruncated
    /**
     * The value that you specified for the `maxitems` parameter in the `ListTrafficPolicyVersions` request that produced the current response.
     */
    val maxItems: kotlin.Int? = builder.maxItems
    /**
     * A list that contains one `TrafficPolicy` element for each traffic policy version that is associated with the specified traffic policy.
     */
    val trafficPolicies: List<TrafficPolicy>? = builder.trafficPolicies
    /**
     * If `IsTruncated` is `true`, the value of `TrafficPolicyVersionMarker` identifies the first traffic policy that Amazon Route 53 will return if you submit another request. Call `ListTrafficPolicyVersions` again and specify the value of `TrafficPolicyVersionMarker` in the `TrafficPolicyVersionMarker` request parameter.
     *
     * This element is present only if `IsTruncated` is `true`.
     */
    val trafficPolicyVersionMarker: kotlin.String? = builder.trafficPolicyVersionMarker

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53.model.ListTrafficPolicyVersionsResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListTrafficPolicyVersionsResponse(")
        append("isTruncated=$isTruncated,")
        append("maxItems=$maxItems,")
        append("trafficPolicies=$trafficPolicies,")
        append("trafficPolicyVersionMarker=$trafficPolicyVersionMarker)")
    }

    override fun hashCode(): kotlin.Int {
        var result = isTruncated.hashCode()
        result = 31 * result + (maxItems ?: 0)
        result = 31 * result + (trafficPolicies?.hashCode() ?: 0)
        result = 31 * result + (trafficPolicyVersionMarker?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListTrafficPolicyVersionsResponse

        if (isTruncated != other.isTruncated) return false
        if (maxItems != other.maxItems) return false
        if (trafficPolicies != other.trafficPolicies) return false
        if (trafficPolicyVersionMarker != other.trafficPolicyVersionMarker) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53.model.ListTrafficPolicyVersionsResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * A flag that indicates whether there are more traffic policies to be listed. If the response was truncated, you can get the next group of traffic policies by submitting another `ListTrafficPolicyVersions` request and specifying the value of `NextMarker` in the `marker` parameter.
         */
        var isTruncated: kotlin.Boolean = false
        /**
         * The value that you specified for the `maxitems` parameter in the `ListTrafficPolicyVersions` request that produced the current response.
         */
        var maxItems: kotlin.Int? = null
        /**
         * A list that contains one `TrafficPolicy` element for each traffic policy version that is associated with the specified traffic policy.
         */
        var trafficPolicies: List<TrafficPolicy>? = null
        /**
         * If `IsTruncated` is `true`, the value of `TrafficPolicyVersionMarker` identifies the first traffic policy that Amazon Route 53 will return if you submit another request. Call `ListTrafficPolicyVersions` again and specify the value of `TrafficPolicyVersionMarker` in the `TrafficPolicyVersionMarker` request parameter.
         *
         * This element is present only if `IsTruncated` is `true`.
         */
        var trafficPolicyVersionMarker: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53.model.ListTrafficPolicyVersionsResponse) : this() {
            this.isTruncated = x.isTruncated
            this.maxItems = x.maxItems
            this.trafficPolicies = x.trafficPolicies
            this.trafficPolicyVersionMarker = x.trafficPolicyVersionMarker
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53.model.ListTrafficPolicyVersionsResponse = ListTrafficPolicyVersionsResponse(this)
    }
}
