// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53.model



/**
 * A complex type that contains information about that can be associated with your hosted zone.
 */
class ListVpcAssociationAuthorizationsRequest private constructor(builder: Builder) {
    /**
     * The ID of the hosted zone for which you want a list of VPCs that can be associated with the hosted zone.
     */
    val hostedZoneId: kotlin.String? = requireNotNull(builder.hostedZoneId) { "A non-null value must be provided for hostedZoneId" }
    /**
     * *Optional*: An integer that specifies the maximum number of VPCs that you want Amazon Route 53 to return. If you don't specify a value for `MaxResults`, Route 53 returns up to 50 VPCs per page.
     */
    val maxResults: kotlin.Int? = builder.maxResults
    /**
     * *Optional*: If a response includes a `NextToken` element, there are more VPCs that can be associated with the specified hosted zone. To get the next page of results, submit another request, and include the value of `NextToken` from the response in the `nexttoken` parameter in another `ListVPCAssociationAuthorizations` request.
     */
    val nextToken: kotlin.String? = builder.nextToken

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53.model.ListVpcAssociationAuthorizationsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListVpcAssociationAuthorizationsRequest(")
        append("hostedZoneId=$hostedZoneId,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = hostedZoneId?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListVpcAssociationAuthorizationsRequest

        if (hostedZoneId != other.hostedZoneId) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53.model.ListVpcAssociationAuthorizationsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The ID of the hosted zone for which you want a list of VPCs that can be associated with the hosted zone.
         */
        var hostedZoneId: kotlin.String? = null
        /**
         * *Optional*: An integer that specifies the maximum number of VPCs that you want Amazon Route 53 to return. If you don't specify a value for `MaxResults`, Route 53 returns up to 50 VPCs per page.
         */
        var maxResults: kotlin.Int? = null
        /**
         * *Optional*: If a response includes a `NextToken` element, there are more VPCs that can be associated with the specified hosted zone. To get the next page of results, submit another request, and include the value of `NextToken` from the response in the `nexttoken` parameter in another `ListVPCAssociationAuthorizations` request.
         */
        var nextToken: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53.model.ListVpcAssociationAuthorizationsRequest) : this() {
            this.hostedZoneId = x.hostedZoneId
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53.model.ListVpcAssociationAuthorizationsRequest = ListVpcAssociationAuthorizationsRequest(this)
    }
}
