// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53.model



/**
 * Information specific to the resource record.
 *
 * If you're creating an alias resource record set, omit `ResourceRecord`.
 */
class ResourceRecord private constructor(builder: Builder) {
    /**
     * The current or new DNS record value, not to exceed 4,000 characters. In the case of a `DELETE` action, if the current value does not match the actual value, an error is returned. For descriptions about how to format `Value` for different record types, see [Supported DNS Resource Record Types](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html) in the *Amazon Route 53 Developer Guide*.
     *
     * You can specify more than one value for all record types except `CNAME` and `SOA`.
     *
     * If you're creating an alias resource record set, omit `Value`.
     */
    val value: kotlin.String? = builder.value

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53.model.ResourceRecord = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResourceRecord(")
        append("value=$value)")
    }

    override fun hashCode(): kotlin.Int {
        var result = value?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResourceRecord

        if (value != other.value) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53.model.ResourceRecord = Builder(this).apply(block).build()

    class Builder {
        /**
         * The current or new DNS record value, not to exceed 4,000 characters. In the case of a `DELETE` action, if the current value does not match the actual value, an error is returned. For descriptions about how to format `Value` for different record types, see [Supported DNS Resource Record Types](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html) in the *Amazon Route 53 Developer Guide*.
         *
         * You can specify more than one value for all record types except `CNAME` and `SOA`.
         *
         * If you're creating an alias resource record set, omit `Value`.
         */
        var value: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53.model.ResourceRecord) : this() {
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53.model.ResourceRecord = ResourceRecord(this)
    }
}
