// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A complex type that contains the status that one Amazon Route 53 health checker reports and the time of the health check.
 */
class StatusReport private constructor(builder: Builder) {
    /**
     * The date and time that the health checker performed the health check in [ISO 8601 format](https://en.wikipedia.org/wiki/ISO_8601) and Coordinated Universal Time (UTC). For example, the value `2017-03-27T17:48:16.751Z` represents March 27, 2017 at 17:48:16.751 UTC.
     */
    val checkedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.checkedTime
    /**
     * A description of the status of the health check endpoint as reported by one of the Amazon Route 53 health checkers.
     */
    val status: kotlin.String? = builder.status

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53.model.StatusReport = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StatusReport(")
        append("checkedTime=$checkedTime,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = checkedTime?.hashCode() ?: 0
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StatusReport

        if (checkedTime != other.checkedTime) return false
        if (status != other.status) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53.model.StatusReport = Builder(this).apply(block).build()

    class Builder {
        /**
         * The date and time that the health checker performed the health check in [ISO 8601 format](https://en.wikipedia.org/wiki/ISO_8601) and Coordinated Universal Time (UTC). For example, the value `2017-03-27T17:48:16.751Z` represents March 27, 2017 at 17:48:16.751 UTC.
         */
        var checkedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A description of the status of the health check endpoint as reported by one of the Amazon Route 53 health checkers.
         */
        var status: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53.model.StatusReport) : this() {
            this.checkedTime = x.checkedTime
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53.model.StatusReport = StatusReport(this)
    }
}
