// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53.model



/**
 * Gets the value that Amazon Route 53 returns in response to a DNS request for a specified record name and type. You can optionally specify the IP address of a DNS resolver, an EDNS0 client subnet IP address, and a subnet mask.
 */
class TestDnsAnswerRequest private constructor(builder: Builder) {
    /**
     * If the resolver that you specified for resolverip supports EDNS0, specify the IPv4 or IPv6 address of a client in the applicable location, for example, `192.0.2.44` or `2001:db8:85a3::8a2e:370:7334`.
     */
    val edns0ClientSubnetIp: kotlin.String? = builder.edns0ClientSubnetIp
    /**
     * If you specify an IP address for `edns0clientsubnetip`, you can optionally specify the number of bits of the IP address that you want the checking tool to include in the DNS query. For example, if you specify `192.0.2.44` for `edns0clientsubnetip` and `24` for `edns0clientsubnetmask`, the checking tool will simulate a request from 192.0.2.0/24. The default value is 24 bits for IPv4 addresses and 64 bits for IPv6 addresses.
     *
     * The range of valid values depends on whether `edns0clientsubnetip` is an IPv4 or an IPv6 address:
     * + **IPv4**: Specify a value between 0 and 32
     * + **IPv6**: Specify a value between 0 and 128
     */
    val edns0ClientSubnetMask: kotlin.String? = builder.edns0ClientSubnetMask
    /**
     * The ID of the hosted zone that you want Amazon Route 53 to simulate a query for.
     */
    val hostedZoneId: kotlin.String? = builder.hostedZoneId
    /**
     * The name of the resource record set that you want Amazon Route 53 to simulate a query for.
     */
    val recordName: kotlin.String? = builder.recordName
    /**
     * The type of the resource record set.
     */
    val recordType: aws.sdk.kotlin.services.route53.model.RrType? = builder.recordType
    /**
     * If you want to simulate a request from a specific DNS resolver, specify the IP address for that resolver. If you omit this value, `TestDnsAnswer` uses the IP address of a DNS resolver in the Amazon Web Services US East (N. Virginia) Region (`us-east-1`).
     */
    val resolverIp: kotlin.String? = builder.resolverIp

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53.model.TestDnsAnswerRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TestDnsAnswerRequest(")
        append("edns0ClientSubnetIp=$edns0ClientSubnetIp,")
        append("edns0ClientSubnetMask=$edns0ClientSubnetMask,")
        append("hostedZoneId=$hostedZoneId,")
        append("recordName=$recordName,")
        append("recordType=$recordType,")
        append("resolverIp=$resolverIp)")
    }

    override fun hashCode(): kotlin.Int {
        var result = edns0ClientSubnetIp?.hashCode() ?: 0
        result = 31 * result + (edns0ClientSubnetMask?.hashCode() ?: 0)
        result = 31 * result + (hostedZoneId?.hashCode() ?: 0)
        result = 31 * result + (recordName?.hashCode() ?: 0)
        result = 31 * result + (recordType?.hashCode() ?: 0)
        result = 31 * result + (resolverIp?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TestDnsAnswerRequest

        if (edns0ClientSubnetIp != other.edns0ClientSubnetIp) return false
        if (edns0ClientSubnetMask != other.edns0ClientSubnetMask) return false
        if (hostedZoneId != other.hostedZoneId) return false
        if (recordName != other.recordName) return false
        if (recordType != other.recordType) return false
        if (resolverIp != other.resolverIp) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53.model.TestDnsAnswerRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * If the resolver that you specified for resolverip supports EDNS0, specify the IPv4 or IPv6 address of a client in the applicable location, for example, `192.0.2.44` or `2001:db8:85a3::8a2e:370:7334`.
         */
        var edns0ClientSubnetIp: kotlin.String? = null
        /**
         * If you specify an IP address for `edns0clientsubnetip`, you can optionally specify the number of bits of the IP address that you want the checking tool to include in the DNS query. For example, if you specify `192.0.2.44` for `edns0clientsubnetip` and `24` for `edns0clientsubnetmask`, the checking tool will simulate a request from 192.0.2.0/24. The default value is 24 bits for IPv4 addresses and 64 bits for IPv6 addresses.
         *
         * The range of valid values depends on whether `edns0clientsubnetip` is an IPv4 or an IPv6 address:
         * + **IPv4**: Specify a value between 0 and 32
         * + **IPv6**: Specify a value between 0 and 128
         */
        var edns0ClientSubnetMask: kotlin.String? = null
        /**
         * The ID of the hosted zone that you want Amazon Route 53 to simulate a query for.
         */
        var hostedZoneId: kotlin.String? = null
        /**
         * The name of the resource record set that you want Amazon Route 53 to simulate a query for.
         */
        var recordName: kotlin.String? = null
        /**
         * The type of the resource record set.
         */
        var recordType: aws.sdk.kotlin.services.route53.model.RrType? = null
        /**
         * If you want to simulate a request from a specific DNS resolver, specify the IP address for that resolver. If you omit this value, `TestDnsAnswer` uses the IP address of a DNS resolver in the Amazon Web Services US East (N. Virginia) Region (`us-east-1`).
         */
        var resolverIp: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53.model.TestDnsAnswerRequest) : this() {
            this.edns0ClientSubnetIp = x.edns0ClientSubnetIp
            this.edns0ClientSubnetMask = x.edns0ClientSubnetMask
            this.hostedZoneId = x.hostedZoneId
            this.recordName = x.recordName
            this.recordType = x.recordType
            this.resolverIp = x.resolverIp
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53.model.TestDnsAnswerRequest = TestDnsAnswerRequest(this)
    }
}
