// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53.model



/**
 * A complex type that contains the response to a `TestDNSAnswer` request.
 */
class TestDnsAnswerResponse private constructor(builder: Builder) {
    /**
     * The Amazon Route 53 name server used to respond to the request.
     */
    val nameserver: kotlin.String? = builder.nameserver
    /**
     * The protocol that Amazon Route 53 used to respond to the request, either `UDP` or `TCP`.
     */
    val protocol: kotlin.String? = builder.protocol
    /**
     * A list that contains values that Amazon Route 53 returned for this resource record set.
     */
    val recordData: List<String>? = builder.recordData
    /**
     * The name of the resource record set that you submitted a request for.
     */
    val recordName: kotlin.String? = builder.recordName
    /**
     * The type of the resource record set that you submitted a request for.
     */
    val recordType: aws.sdk.kotlin.services.route53.model.RrType? = builder.recordType
    /**
     * A code that indicates whether the request is valid or not. The most common response code is `NOERROR`, meaning that the request is valid. If the response is not valid, Amazon Route 53 returns a response code that describes the error. For a list of possible response codes, see [DNS RCODES](http://www.iana.org/assignments/dns-parameters/dns-parameters.xhtml#dns-parameters-6) on the IANA website.
     */
    val responseCode: kotlin.String? = builder.responseCode

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53.model.TestDnsAnswerResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TestDnsAnswerResponse(")
        append("nameserver=$nameserver,")
        append("protocol=$protocol,")
        append("recordData=$recordData,")
        append("recordName=$recordName,")
        append("recordType=$recordType,")
        append("responseCode=$responseCode)")
    }

    override fun hashCode(): kotlin.Int {
        var result = nameserver?.hashCode() ?: 0
        result = 31 * result + (protocol?.hashCode() ?: 0)
        result = 31 * result + (recordData?.hashCode() ?: 0)
        result = 31 * result + (recordName?.hashCode() ?: 0)
        result = 31 * result + (recordType?.hashCode() ?: 0)
        result = 31 * result + (responseCode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TestDnsAnswerResponse

        if (nameserver != other.nameserver) return false
        if (protocol != other.protocol) return false
        if (recordData != other.recordData) return false
        if (recordName != other.recordName) return false
        if (recordType != other.recordType) return false
        if (responseCode != other.responseCode) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53.model.TestDnsAnswerResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Route 53 name server used to respond to the request.
         */
        var nameserver: kotlin.String? = null
        /**
         * The protocol that Amazon Route 53 used to respond to the request, either `UDP` or `TCP`.
         */
        var protocol: kotlin.String? = null
        /**
         * A list that contains values that Amazon Route 53 returned for this resource record set.
         */
        var recordData: List<String>? = null
        /**
         * The name of the resource record set that you submitted a request for.
         */
        var recordName: kotlin.String? = null
        /**
         * The type of the resource record set that you submitted a request for.
         */
        var recordType: aws.sdk.kotlin.services.route53.model.RrType? = null
        /**
         * A code that indicates whether the request is valid or not. The most common response code is `NOERROR`, meaning that the request is valid. If the response is not valid, Amazon Route 53 returns a response code that describes the error. For a list of possible response codes, see [DNS RCODES](http://www.iana.org/assignments/dns-parameters/dns-parameters.xhtml#dns-parameters-6) on the IANA website.
         */
        var responseCode: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53.model.TestDnsAnswerResponse) : this() {
            this.nameserver = x.nameserver
            this.protocol = x.protocol
            this.recordData = x.recordData
            this.recordName = x.recordName
            this.recordType = x.recordType
            this.responseCode = x.responseCode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53.model.TestDnsAnswerResponse = TestDnsAnswerResponse(this)
    }
}
