// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53.model



/**
 * A complex type that contains settings for a traffic policy.
 */
class TrafficPolicy private constructor(builder: Builder) {
    /**
     * The comment that you specify in the `CreateTrafficPolicy` request, if any.
     */
    val comment: kotlin.String? = builder.comment
    /**
     * The definition of a traffic policy in JSON format. You specify the JSON document to use for a new traffic policy in the `CreateTrafficPolicy` request. For more information about the JSON format, see [Traffic Policy Document Format](https://docs.aws.amazon.com/Route53/latest/APIReference/api-policies-traffic-policy-document-format.html).
     */
    val document: kotlin.String? = builder.document
    /**
     * The ID that Amazon Route 53 assigned to a traffic policy when you created it.
     */
    val id: kotlin.String? = builder.id
    /**
     * The name that you specified when you created the traffic policy.
     */
    val name: kotlin.String? = builder.name
    /**
     * The DNS type of the resource record sets that Amazon Route 53 creates when you use a traffic policy to create a traffic policy instance.
     */
    val type: aws.sdk.kotlin.services.route53.model.RrType? = builder.type
    /**
     * The version number that Amazon Route 53 assigns to a traffic policy. For a new traffic policy, the value of `Version` is always 1.
     */
    val version: kotlin.Int? = builder.version

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53.model.TrafficPolicy = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TrafficPolicy(")
        append("comment=$comment,")
        append("document=$document,")
        append("id=$id,")
        append("name=$name,")
        append("type=$type,")
        append("version=$version)")
    }

    override fun hashCode(): kotlin.Int {
        var result = comment?.hashCode() ?: 0
        result = 31 * result + (document?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (version ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TrafficPolicy

        if (comment != other.comment) return false
        if (document != other.document) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (type != other.type) return false
        if (version != other.version) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53.model.TrafficPolicy = Builder(this).apply(block).build()

    class Builder {
        /**
         * The comment that you specify in the `CreateTrafficPolicy` request, if any.
         */
        var comment: kotlin.String? = null
        /**
         * The definition of a traffic policy in JSON format. You specify the JSON document to use for a new traffic policy in the `CreateTrafficPolicy` request. For more information about the JSON format, see [Traffic Policy Document Format](https://docs.aws.amazon.com/Route53/latest/APIReference/api-policies-traffic-policy-document-format.html).
         */
        var document: kotlin.String? = null
        /**
         * The ID that Amazon Route 53 assigned to a traffic policy when you created it.
         */
        var id: kotlin.String? = null
        /**
         * The name that you specified when you created the traffic policy.
         */
        var name: kotlin.String? = null
        /**
         * The DNS type of the resource record sets that Amazon Route 53 creates when you use a traffic policy to create a traffic policy instance.
         */
        var type: aws.sdk.kotlin.services.route53.model.RrType? = null
        /**
         * The version number that Amazon Route 53 assigns to a traffic policy. For a new traffic policy, the value of `Version` is always 1.
         */
        var version: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53.model.TrafficPolicy) : this() {
            this.comment = x.comment
            this.document = x.document
            this.id = x.id
            this.name = x.name
            this.type = x.type
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53.model.TrafficPolicy = TrafficPolicy(this)
    }
}
