// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53.model



/**
 * A complex type that contains settings for the new traffic policy instance.
 */
class TrafficPolicyInstance private constructor(builder: Builder) {
    /**
     * The ID of the hosted zone that Amazon Route 53 created resource record sets in.
     */
    val hostedZoneId: kotlin.String? = builder.hostedZoneId
    /**
     * The ID that Amazon Route 53 assigned to the new traffic policy instance.
     */
    val id: kotlin.String? = builder.id
    /**
     * If `State` is `Failed`, an explanation of the reason for the failure. If `State` is another value, `Message` is empty.
     */
    val message: kotlin.String? = builder.message
    /**
     * The DNS name, such as www.example.com, for which Amazon Route 53 responds to queries by using the resource record sets that are associated with this traffic policy instance.
     */
    val name: kotlin.String? = builder.name
    /**
     * The value of `State` is one of the following values:
     *
     * ## Applied
     * Amazon Route 53 has finished creating resource record sets, and changes have propagated to all Route 53 edge locations.
     *
     * ## Creating
     * Route 53 is creating the resource record sets. Use `GetTrafficPolicyInstance` to confirm that the `CreateTrafficPolicyInstance` request completed successfully.
     *
     * ## Failed
     * Route 53 wasn't able to create or update the resource record sets. When the value of `State` is `Failed`, see `Message` for an explanation of what caused the request to fail.
     */
    val state: kotlin.String? = builder.state
    /**
     * The ID of the traffic policy that Amazon Route 53 used to create resource record sets in the specified hosted zone.
     */
    val trafficPolicyId: kotlin.String? = builder.trafficPolicyId
    /**
     * The DNS type that Amazon Route 53 assigned to all of the resource record sets that it created for this traffic policy instance.
     */
    val trafficPolicyType: aws.sdk.kotlin.services.route53.model.RrType? = builder.trafficPolicyType
    /**
     * The version of the traffic policy that Amazon Route 53 used to create resource record sets in the specified hosted zone.
     */
    val trafficPolicyVersion: kotlin.Int? = builder.trafficPolicyVersion
    /**
     * The TTL that Amazon Route 53 assigned to all of the resource record sets that it created in the specified hosted zone.
     */
    val ttl: kotlin.Long? = builder.ttl

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53.model.TrafficPolicyInstance = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TrafficPolicyInstance(")
        append("hostedZoneId=$hostedZoneId,")
        append("id=$id,")
        append("message=$message,")
        append("name=$name,")
        append("state=$state,")
        append("trafficPolicyId=$trafficPolicyId,")
        append("trafficPolicyType=$trafficPolicyType,")
        append("trafficPolicyVersion=$trafficPolicyVersion,")
        append("ttl=$ttl)")
    }

    override fun hashCode(): kotlin.Int {
        var result = hostedZoneId?.hashCode() ?: 0
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (trafficPolicyId?.hashCode() ?: 0)
        result = 31 * result + (trafficPolicyType?.hashCode() ?: 0)
        result = 31 * result + (trafficPolicyVersion ?: 0)
        result = 31 * result + (ttl?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TrafficPolicyInstance

        if (hostedZoneId != other.hostedZoneId) return false
        if (id != other.id) return false
        if (message != other.message) return false
        if (name != other.name) return false
        if (state != other.state) return false
        if (trafficPolicyId != other.trafficPolicyId) return false
        if (trafficPolicyType != other.trafficPolicyType) return false
        if (trafficPolicyVersion != other.trafficPolicyVersion) return false
        if (ttl != other.ttl) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53.model.TrafficPolicyInstance = Builder(this).apply(block).build()

    class Builder {
        /**
         * The ID of the hosted zone that Amazon Route 53 created resource record sets in.
         */
        var hostedZoneId: kotlin.String? = null
        /**
         * The ID that Amazon Route 53 assigned to the new traffic policy instance.
         */
        var id: kotlin.String? = null
        /**
         * If `State` is `Failed`, an explanation of the reason for the failure. If `State` is another value, `Message` is empty.
         */
        var message: kotlin.String? = null
        /**
         * The DNS name, such as www.example.com, for which Amazon Route 53 responds to queries by using the resource record sets that are associated with this traffic policy instance.
         */
        var name: kotlin.String? = null
        /**
         * The value of `State` is one of the following values:
         *
         * ## Applied
         * Amazon Route 53 has finished creating resource record sets, and changes have propagated to all Route 53 edge locations.
         *
         * ## Creating
         * Route 53 is creating the resource record sets. Use `GetTrafficPolicyInstance` to confirm that the `CreateTrafficPolicyInstance` request completed successfully.
         *
         * ## Failed
         * Route 53 wasn't able to create or update the resource record sets. When the value of `State` is `Failed`, see `Message` for an explanation of what caused the request to fail.
         */
        var state: kotlin.String? = null
        /**
         * The ID of the traffic policy that Amazon Route 53 used to create resource record sets in the specified hosted zone.
         */
        var trafficPolicyId: kotlin.String? = null
        /**
         * The DNS type that Amazon Route 53 assigned to all of the resource record sets that it created for this traffic policy instance.
         */
        var trafficPolicyType: aws.sdk.kotlin.services.route53.model.RrType? = null
        /**
         * The version of the traffic policy that Amazon Route 53 used to create resource record sets in the specified hosted zone.
         */
        var trafficPolicyVersion: kotlin.Int? = null
        /**
         * The TTL that Amazon Route 53 assigned to all of the resource record sets that it created in the specified hosted zone.
         */
        var ttl: kotlin.Long? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53.model.TrafficPolicyInstance) : this() {
            this.hostedZoneId = x.hostedZoneId
            this.id = x.id
            this.message = x.message
            this.name = x.name
            this.state = x.state
            this.trafficPolicyId = x.trafficPolicyId
            this.trafficPolicyType = x.trafficPolicyType
            this.trafficPolicyVersion = x.trafficPolicyVersion
            this.ttl = x.ttl
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53.model.TrafficPolicyInstance = TrafficPolicyInstance(this)
    }
}
