// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53.model



/**
 * A complex type that contains information about the latest version of one traffic policy that is associated with the current Amazon Web Services account.
 */
class TrafficPolicySummary private constructor(builder: Builder) {
    /**
     * The ID that Amazon Route 53 assigned to the traffic policy when you created it.
     */
    val id: kotlin.String? = builder.id
    /**
     * The version number of the latest version of the traffic policy.
     */
    val latestVersion: kotlin.Int? = builder.latestVersion
    /**
     * The name that you specified for the traffic policy when you created it.
     */
    val name: kotlin.String? = builder.name
    /**
     * The number of traffic policies that are associated with the current Amazon Web Services account.
     */
    val trafficPolicyCount: kotlin.Int? = builder.trafficPolicyCount
    /**
     * The DNS type of the resource record sets that Amazon Route 53 creates when you use a traffic policy to create a traffic policy instance.
     */
    val type: aws.sdk.kotlin.services.route53.model.RrType? = builder.type

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53.model.TrafficPolicySummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TrafficPolicySummary(")
        append("id=$id,")
        append("latestVersion=$latestVersion,")
        append("name=$name,")
        append("trafficPolicyCount=$trafficPolicyCount,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = id?.hashCode() ?: 0
        result = 31 * result + (latestVersion ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (trafficPolicyCount ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TrafficPolicySummary

        if (id != other.id) return false
        if (latestVersion != other.latestVersion) return false
        if (name != other.name) return false
        if (trafficPolicyCount != other.trafficPolicyCount) return false
        if (type != other.type) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53.model.TrafficPolicySummary = Builder(this).apply(block).build()

    class Builder {
        /**
         * The ID that Amazon Route 53 assigned to the traffic policy when you created it.
         */
        var id: kotlin.String? = null
        /**
         * The version number of the latest version of the traffic policy.
         */
        var latestVersion: kotlin.Int? = null
        /**
         * The name that you specified for the traffic policy when you created it.
         */
        var name: kotlin.String? = null
        /**
         * The number of traffic policies that are associated with the current Amazon Web Services account.
         */
        var trafficPolicyCount: kotlin.Int? = null
        /**
         * The DNS type of the resource record sets that Amazon Route 53 creates when you use a traffic policy to create a traffic policy instance.
         */
        var type: aws.sdk.kotlin.services.route53.model.RrType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53.model.TrafficPolicySummary) : this() {
            this.id = x.id
            this.latestVersion = x.latestVersion
            this.name = x.name
            this.trafficPolicyCount = x.trafficPolicyCount
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53.model.TrafficPolicySummary = TrafficPolicySummary(this)
    }
}
