// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53.paginators

import aws.sdk.kotlin.services.route53.Route53Client
import aws.sdk.kotlin.services.route53.model.CidrBlockSummary
import aws.sdk.kotlin.services.route53.model.CollectionSummary
import aws.sdk.kotlin.services.route53.model.HealthCheck
import aws.sdk.kotlin.services.route53.model.HostedZone
import aws.sdk.kotlin.services.route53.model.ListCidrBlocksRequest
import aws.sdk.kotlin.services.route53.model.ListCidrBlocksResponse
import aws.sdk.kotlin.services.route53.model.ListCidrCollectionsRequest
import aws.sdk.kotlin.services.route53.model.ListCidrCollectionsResponse
import aws.sdk.kotlin.services.route53.model.ListCidrLocationsRequest
import aws.sdk.kotlin.services.route53.model.ListCidrLocationsResponse
import aws.sdk.kotlin.services.route53.model.ListHealthChecksRequest
import aws.sdk.kotlin.services.route53.model.ListHealthChecksResponse
import aws.sdk.kotlin.services.route53.model.ListHostedZonesRequest
import aws.sdk.kotlin.services.route53.model.ListHostedZonesResponse
import aws.sdk.kotlin.services.route53.model.ListQueryLoggingConfigsRequest
import aws.sdk.kotlin.services.route53.model.ListQueryLoggingConfigsResponse
import aws.sdk.kotlin.services.route53.model.LocationSummary
import aws.sdk.kotlin.services.route53.model.QueryLoggingConfig
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListCidrBlocksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListCidrBlocksRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCidrBlocksResponse]
 */
fun Route53Client.listCidrBlocksPaginated(initialRequest: ListCidrBlocksRequest): Flow<ListCidrBlocksResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listCidrBlocksPaginated.listCidrBlocks(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListCidrBlocksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCidrBlocksResponse]
 */
fun Route53Client.listCidrBlocksPaginated(block: ListCidrBlocksRequest.Builder.() -> Unit): Flow<ListCidrBlocksResponse> =
    listCidrBlocksPaginated(ListCidrBlocksRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listCidrBlocksPaginated]
 * to access the nested member [CidrBlockSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [CidrBlockSummary]
 */
@JvmName("listCidrBlocksResponseCidrBlockSummary")
fun Flow<ListCidrBlocksResponse>.cidrBlocks(): Flow<CidrBlockSummary> =
    transform() { response ->
        response.cidrBlocks?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListCidrCollectionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListCidrCollectionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCidrCollectionsResponse]
 */
fun Route53Client.listCidrCollectionsPaginated(initialRequest: ListCidrCollectionsRequest): Flow<ListCidrCollectionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listCidrCollectionsPaginated.listCidrCollections(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListCidrCollectionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCidrCollectionsResponse]
 */
fun Route53Client.listCidrCollectionsPaginated(block: ListCidrCollectionsRequest.Builder.() -> Unit): Flow<ListCidrCollectionsResponse> =
    listCidrCollectionsPaginated(ListCidrCollectionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listCidrCollectionsPaginated]
 * to access the nested member [CollectionSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [CollectionSummary]
 */
@JvmName("listCidrCollectionsResponseCollectionSummary")
fun Flow<ListCidrCollectionsResponse>.cidrCollections(): Flow<CollectionSummary> =
    transform() { response ->
        response.cidrCollections?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListCidrLocationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListCidrLocationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCidrLocationsResponse]
 */
fun Route53Client.listCidrLocationsPaginated(initialRequest: ListCidrLocationsRequest): Flow<ListCidrLocationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listCidrLocationsPaginated.listCidrLocations(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListCidrLocationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCidrLocationsResponse]
 */
fun Route53Client.listCidrLocationsPaginated(block: ListCidrLocationsRequest.Builder.() -> Unit): Flow<ListCidrLocationsResponse> =
    listCidrLocationsPaginated(ListCidrLocationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listCidrLocationsPaginated]
 * to access the nested member [LocationSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [LocationSummary]
 */
@JvmName("listCidrLocationsResponseLocationSummary")
fun Flow<ListCidrLocationsResponse>.cidrLocations(): Flow<LocationSummary> =
    transform() { response ->
        response.cidrLocations?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListHealthChecksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListHealthChecksRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListHealthChecksResponse]
 */
fun Route53Client.listHealthChecksPaginated(initialRequest: ListHealthChecksRequest): Flow<ListHealthChecksResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listHealthChecksPaginated.listHealthChecks(req)
            isFirstPage = false
            cursor = result.nextMarker
            emit(result)
        }
    }

/**
 * Paginate over [ListHealthChecksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListHealthChecksResponse]
 */
fun Route53Client.listHealthChecksPaginated(block: ListHealthChecksRequest.Builder.() -> Unit): Flow<ListHealthChecksResponse> =
    listHealthChecksPaginated(ListHealthChecksRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listHealthChecksPaginated]
 * to access the nested member [HealthCheck]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [HealthCheck]
 */
@JvmName("listHealthChecksResponseHealthCheck")
fun Flow<ListHealthChecksResponse>.healthChecks(): Flow<HealthCheck> =
    transform() { response ->
        response.healthChecks?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListHostedZonesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListHostedZonesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListHostedZonesResponse]
 */
fun Route53Client.listHostedZonesPaginated(initialRequest: ListHostedZonesRequest): Flow<ListHostedZonesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listHostedZonesPaginated.listHostedZones(req)
            isFirstPage = false
            cursor = result.nextMarker
            emit(result)
        }
    }

/**
 * Paginate over [ListHostedZonesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListHostedZonesResponse]
 */
fun Route53Client.listHostedZonesPaginated(block: ListHostedZonesRequest.Builder.() -> Unit): Flow<ListHostedZonesResponse> =
    listHostedZonesPaginated(ListHostedZonesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listHostedZonesPaginated]
 * to access the nested member [HostedZone]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [HostedZone]
 */
@JvmName("listHostedZonesResponseHostedZone")
fun Flow<ListHostedZonesResponse>.hostedZones(): Flow<HostedZone> =
    transform() { response ->
        response.hostedZones?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListQueryLoggingConfigsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListQueryLoggingConfigsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListQueryLoggingConfigsResponse]
 */
fun Route53Client.listQueryLoggingConfigsPaginated(initialRequest: ListQueryLoggingConfigsRequest): Flow<ListQueryLoggingConfigsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listQueryLoggingConfigsPaginated.listQueryLoggingConfigs(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListQueryLoggingConfigsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListQueryLoggingConfigsResponse]
 */
fun Route53Client.listQueryLoggingConfigsPaginated(block: ListQueryLoggingConfigsRequest.Builder.() -> Unit): Flow<ListQueryLoggingConfigsResponse> =
    listQueryLoggingConfigsPaginated(ListQueryLoggingConfigsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listQueryLoggingConfigsPaginated]
 * to access the nested member [QueryLoggingConfig]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [QueryLoggingConfig]
 */
@JvmName("listQueryLoggingConfigsResponseQueryLoggingConfig")
fun Flow<ListQueryLoggingConfigsResponse>.queryLoggingConfigs(): Flow<QueryLoggingConfig> =
    transform() { response ->
        response.queryLoggingConfigs?.forEach {
            emit(it)
        }
    }
