// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.route53.model.AssociateVpcWithHostedZoneResponse
import aws.sdk.kotlin.services.route53.model.ChangeInfo
import aws.sdk.kotlin.services.route53.model.Route53Exception
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class AssociateVPCWithHostedZoneOperationDeserializer: HttpDeserialize<AssociateVpcWithHostedZoneResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): AssociateVpcWithHostedZoneResponse {
        if (!response.status.isSuccess()) {
            throwAssociateVpcWithHostedZoneError(context, response)
        }
        val builder = AssociateVpcWithHostedZoneResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeAssociateVPCWithHostedZoneOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwAssociateVpcWithHostedZoneError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw Route53Exception("Failed to parse response as 'restXml' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ConflictingDomainExists" -> ConflictingDomainExistsDeserializer().deserialize(context, wrappedResponse)
        "InvalidInput" -> InvalidInputDeserializer().deserialize(context, wrappedResponse)
        "InvalidVPCId" -> InvalidVpcIdDeserializer().deserialize(context, wrappedResponse)
        "LimitsExceeded" -> LimitsExceededDeserializer().deserialize(context, wrappedResponse)
        "NoSuchHostedZone" -> NoSuchHostedZoneDeserializer().deserialize(context, wrappedResponse)
        "NotAuthorizedException" -> NotAuthorizedExceptionDeserializer().deserialize(context, wrappedResponse)
        "PriorRequestNotComplete" -> PriorRequestNotCompleteDeserializer().deserialize(context, wrappedResponse)
        "PublicZoneVPCAssociation" -> PublicZoneVpcAssociationDeserializer().deserialize(context, wrappedResponse)
        else -> Route53Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeAssociateVPCWithHostedZoneOperationBody(builder: AssociateVpcWithHostedZoneResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    val CHANGEINFO_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("ChangeInfo"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlSerialName("AssociateVPCWithHostedZoneResponse"))
        trait(XmlNamespace("https://route53.amazonaws.com/doc/2013-04-01/"))
        field(CHANGEINFO_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CHANGEINFO_DESCRIPTOR.index -> builder.changeInfo = deserializeChangeInfoDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
