// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.route53.model.ChangeInfo
import aws.sdk.kotlin.services.route53.model.CreateKeySigningKeyResponse
import aws.sdk.kotlin.services.route53.model.KeySigningKey
import aws.sdk.kotlin.services.route53.model.Route53Exception
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class CreateKeySigningKeyOperationDeserializer: HttpDeserialize<CreateKeySigningKeyResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateKeySigningKeyResponse {
        if (!response.status.isSuccess()) {
            throwCreateKeySigningKeyError(context, response)
        }
        val builder = CreateKeySigningKeyResponse.Builder()

        builder.location = response.headers["Location"]

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateKeySigningKeyOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateKeySigningKeyError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw Route53Exception("Failed to parse response as 'restXml' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ConcurrentModification" -> ConcurrentModificationDeserializer().deserialize(context, wrappedResponse)
        "InvalidArgument" -> InvalidArgumentDeserializer().deserialize(context, wrappedResponse)
        "InvalidInput" -> InvalidInputDeserializer().deserialize(context, wrappedResponse)
        "InvalidKeySigningKeyName" -> InvalidKeySigningKeyNameDeserializer().deserialize(context, wrappedResponse)
        "InvalidKeySigningKeyStatus" -> InvalidKeySigningKeyStatusDeserializer().deserialize(context, wrappedResponse)
        "InvalidKMSArn" -> InvalidKmsArnDeserializer().deserialize(context, wrappedResponse)
        "InvalidSigningStatus" -> InvalidSigningStatusDeserializer().deserialize(context, wrappedResponse)
        "KeySigningKeyAlreadyExists" -> KeySigningKeyAlreadyExistsDeserializer().deserialize(context, wrappedResponse)
        "NoSuchHostedZone" -> NoSuchHostedZoneDeserializer().deserialize(context, wrappedResponse)
        "TooManyKeySigningKeys" -> TooManyKeySigningKeysDeserializer().deserialize(context, wrappedResponse)
        else -> Route53Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateKeySigningKeyOperationBody(builder: CreateKeySigningKeyResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    val CHANGEINFO_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("ChangeInfo"))
    val KEYSIGNINGKEY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("KeySigningKey"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlSerialName("CreateKeySigningKeyResponse"))
        trait(XmlNamespace("https://route53.amazonaws.com/doc/2013-04-01/"))
        field(CHANGEINFO_DESCRIPTOR)
        field(KEYSIGNINGKEY_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CHANGEINFO_DESCRIPTOR.index -> builder.changeInfo = deserializeChangeInfoDocument(deserializer)
                KEYSIGNINGKEY_DESCRIPTOR.index -> builder.keySigningKey = deserializeKeySigningKeyDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
