// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.route53.model.CreateTrafficPolicyVersionResponse
import aws.sdk.kotlin.services.route53.model.Route53Exception
import aws.sdk.kotlin.services.route53.model.TrafficPolicy
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class CreateTrafficPolicyVersionOperationDeserializer: HttpDeserialize<CreateTrafficPolicyVersionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateTrafficPolicyVersionResponse {
        if (!response.status.isSuccess()) {
            throwCreateTrafficPolicyVersionError(context, response)
        }
        val builder = CreateTrafficPolicyVersionResponse.Builder()

        builder.location = response.headers["Location"]

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateTrafficPolicyVersionOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateTrafficPolicyVersionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw Route53Exception("Failed to parse response as 'restXml' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ConcurrentModification" -> ConcurrentModificationDeserializer().deserialize(context, wrappedResponse)
        "InvalidInput" -> InvalidInputDeserializer().deserialize(context, wrappedResponse)
        "InvalidTrafficPolicyDocument" -> InvalidTrafficPolicyDocumentDeserializer().deserialize(context, wrappedResponse)
        "NoSuchTrafficPolicy" -> NoSuchTrafficPolicyDeserializer().deserialize(context, wrappedResponse)
        "TooManyTrafficPolicyVersionsForCurrentPolicy" -> TooManyTrafficPolicyVersionsForCurrentPolicyDeserializer().deserialize(context, wrappedResponse)
        else -> Route53Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateTrafficPolicyVersionOperationBody(builder: CreateTrafficPolicyVersionResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    val TRAFFICPOLICY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("TrafficPolicy"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlSerialName("CreateTrafficPolicyVersionResponse"))
        trait(XmlNamespace("https://route53.amazonaws.com/doc/2013-04-01/"))
        field(TRAFFICPOLICY_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                TRAFFICPOLICY_DESCRIPTOR.index -> builder.trafficPolicy = deserializeTrafficPolicyDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
