// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.route53.model.CreateVpcAssociationAuthorizationResponse
import aws.sdk.kotlin.services.route53.model.Route53Exception
import aws.sdk.kotlin.services.route53.model.Vpc
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class CreateVPCAssociationAuthorizationOperationDeserializer: HttpDeserialize<CreateVpcAssociationAuthorizationResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateVpcAssociationAuthorizationResponse {
        if (!response.status.isSuccess()) {
            throwCreateVpcAssociationAuthorizationError(context, response)
        }
        val builder = CreateVpcAssociationAuthorizationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateVPCAssociationAuthorizationOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateVpcAssociationAuthorizationError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw Route53Exception("Failed to parse response as 'restXml' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ConcurrentModification" -> ConcurrentModificationDeserializer().deserialize(context, wrappedResponse)
        "InvalidInput" -> InvalidInputDeserializer().deserialize(context, wrappedResponse)
        "InvalidVPCId" -> InvalidVpcIdDeserializer().deserialize(context, wrappedResponse)
        "NoSuchHostedZone" -> NoSuchHostedZoneDeserializer().deserialize(context, wrappedResponse)
        "TooManyVPCAssociationAuthorizations" -> TooManyVpcAssociationAuthorizationsDeserializer().deserialize(context, wrappedResponse)
        else -> Route53Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateVPCAssociationAuthorizationOperationBody(builder: CreateVpcAssociationAuthorizationResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    val HOSTEDZONEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("HostedZoneId"))
    val VPC_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("VPC"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlSerialName("CreateVPCAssociationAuthorizationResponse"))
        trait(XmlNamespace("https://route53.amazonaws.com/doc/2013-04-01/"))
        field(HOSTEDZONEID_DESCRIPTOR)
        field(VPC_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                HOSTEDZONEID_DESCRIPTOR.index -> builder.hostedZoneId = deserializeString()
                VPC_DESCRIPTOR.index -> builder.vpc = deserializeVpcDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
