// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.route53.model.DeleteVpcAssociationAuthorizationResponse
import aws.sdk.kotlin.services.route53.model.Route53Exception
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse


internal class DeleteVPCAssociationAuthorizationOperationDeserializer: HttpDeserialize<DeleteVpcAssociationAuthorizationResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DeleteVpcAssociationAuthorizationResponse {
        if (!response.status.isSuccess()) {
            throwDeleteVpcAssociationAuthorizationError(context, response)
        }
        val builder = DeleteVpcAssociationAuthorizationResponse.Builder()

        return builder.build()
    }
}

private suspend fun throwDeleteVpcAssociationAuthorizationError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw Route53Exception("Failed to parse response as 'restXml' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ConcurrentModification" -> ConcurrentModificationDeserializer().deserialize(context, wrappedResponse)
        "InvalidInput" -> InvalidInputDeserializer().deserialize(context, wrappedResponse)
        "InvalidVPCId" -> InvalidVpcIdDeserializer().deserialize(context, wrappedResponse)
        "NoSuchHostedZone" -> NoSuchHostedZoneDeserializer().deserialize(context, wrappedResponse)
        "VPCAssociationAuthorizationNotFound" -> VpcAssociationAuthorizationNotFoundDeserializer().deserialize(context, wrappedResponse)
        else -> Route53Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
