// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.route53.model.ChangeInfo
import aws.sdk.kotlin.services.route53.model.DisableHostedZoneDnssecResponse
import aws.sdk.kotlin.services.route53.model.Route53Exception
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class DisableHostedZoneDNSSECOperationDeserializer: HttpDeserialize<DisableHostedZoneDnssecResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DisableHostedZoneDnssecResponse {
        if (!response.status.isSuccess()) {
            throwDisableHostedZoneDnssecError(context, response)
        }
        val builder = DisableHostedZoneDnssecResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDisableHostedZoneDNSSECOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDisableHostedZoneDnssecError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw Route53Exception("Failed to parse response as 'restXml' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ConcurrentModification" -> ConcurrentModificationDeserializer().deserialize(context, wrappedResponse)
        "DNSSECNotFound" -> DnssecNotFoundDeserializer().deserialize(context, wrappedResponse)
        "InvalidArgument" -> InvalidArgumentDeserializer().deserialize(context, wrappedResponse)
        "InvalidInput" -> InvalidInputDeserializer().deserialize(context, wrappedResponse)
        "InvalidKeySigningKeyStatus" -> InvalidKeySigningKeyStatusDeserializer().deserialize(context, wrappedResponse)
        "InvalidKMSArn" -> InvalidKmsArnDeserializer().deserialize(context, wrappedResponse)
        "KeySigningKeyInParentDSRecord" -> KeySigningKeyInParentDsRecordDeserializer().deserialize(context, wrappedResponse)
        "NoSuchHostedZone" -> NoSuchHostedZoneDeserializer().deserialize(context, wrappedResponse)
        else -> Route53Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDisableHostedZoneDNSSECOperationBody(builder: DisableHostedZoneDnssecResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    val CHANGEINFO_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("ChangeInfo"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlSerialName("DisableHostedZoneDNSSECResponse"))
        trait(XmlNamespace("https://route53.amazonaws.com/doc/2013-04-01/"))
        field(CHANGEINFO_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CHANGEINFO_DESCRIPTOR.index -> builder.changeInfo = deserializeChangeInfoDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
