// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.route53.model.GetQueryLoggingConfigResponse
import aws.sdk.kotlin.services.route53.model.QueryLoggingConfig
import aws.sdk.kotlin.services.route53.model.Route53Exception
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class GetQueryLoggingConfigOperationDeserializer: HttpDeserialize<GetQueryLoggingConfigResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetQueryLoggingConfigResponse {
        if (!response.status.isSuccess()) {
            throwGetQueryLoggingConfigError(context, response)
        }
        val builder = GetQueryLoggingConfigResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetQueryLoggingConfigOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetQueryLoggingConfigError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw Route53Exception("Failed to parse response as 'restXml' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidInput" -> InvalidInputDeserializer().deserialize(context, wrappedResponse)
        "NoSuchQueryLoggingConfig" -> NoSuchQueryLoggingConfigDeserializer().deserialize(context, wrappedResponse)
        else -> Route53Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetQueryLoggingConfigOperationBody(builder: GetQueryLoggingConfigResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    val QUERYLOGGINGCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("QueryLoggingConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlSerialName("GetQueryLoggingConfigResponse"))
        trait(XmlNamespace("https://route53.amazonaws.com/doc/2013-04-01/"))
        field(QUERYLOGGINGCONFIG_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                QUERYLOGGINGCONFIG_DESCRIPTOR.index -> builder.queryLoggingConfig = deserializeQueryLoggingConfigDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
