// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.route53.model.HostedZone
import aws.sdk.kotlin.services.route53.model.ListHostedZonesByNameResponse
import aws.sdk.kotlin.services.route53.model.Route53Exception
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlCollectionName
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class ListHostedZonesByNameOperationDeserializer: HttpDeserialize<ListHostedZonesByNameResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListHostedZonesByNameResponse {
        if (!response.status.isSuccess()) {
            throwListHostedZonesByNameError(context, response)
        }
        val builder = ListHostedZonesByNameResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListHostedZonesByNameOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListHostedZonesByNameError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw Route53Exception("Failed to parse response as 'restXml' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidDomainName" -> InvalidDomainNameDeserializer().deserialize(context, wrappedResponse)
        "InvalidInput" -> InvalidInputDeserializer().deserialize(context, wrappedResponse)
        else -> Route53Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListHostedZonesByNameOperationBody(builder: ListHostedZonesByNameResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    val DNSNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("DNSName"))
    val HOSTEDZONEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("HostedZoneId"))
    val HOSTEDZONES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("HostedZones"), XmlCollectionName("HostedZone"))
    val ISTRUNCATED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, XmlSerialName("IsTruncated"))
    val MAXITEMS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, XmlSerialName("MaxItems"))
    val NEXTDNSNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("NextDNSName"))
    val NEXTHOSTEDZONEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("NextHostedZoneId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlSerialName("ListHostedZonesByNameResponse"))
        trait(XmlNamespace("https://route53.amazonaws.com/doc/2013-04-01/"))
        field(DNSNAME_DESCRIPTOR)
        field(HOSTEDZONEID_DESCRIPTOR)
        field(HOSTEDZONES_DESCRIPTOR)
        field(ISTRUNCATED_DESCRIPTOR)
        field(MAXITEMS_DESCRIPTOR)
        field(NEXTDNSNAME_DESCRIPTOR)
        field(NEXTHOSTEDZONEID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DNSNAME_DESCRIPTOR.index -> builder.dnsName = deserializeString()
                HOSTEDZONEID_DESCRIPTOR.index -> builder.hostedZoneId = deserializeString()
                HOSTEDZONES_DESCRIPTOR.index -> builder.hostedZones =
                    deserializer.deserializeList(HOSTEDZONES_DESCRIPTOR) {
                        val col0 = mutableListOf<HostedZone>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeHostedZoneDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ISTRUNCATED_DESCRIPTOR.index -> builder.isTruncated = deserializeBoolean()
                MAXITEMS_DESCRIPTOR.index -> builder.maxItems = deserializeInt()
                NEXTDNSNAME_DESCRIPTOR.index -> builder.nextDnsName = deserializeString()
                NEXTHOSTEDZONEID_DESCRIPTOR.index -> builder.nextHostedZoneId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
