// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.route53.model.HostedZoneSummary
import aws.sdk.kotlin.services.route53.model.ListHostedZonesByVpcResponse
import aws.sdk.kotlin.services.route53.model.Route53Exception
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlCollectionName
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class ListHostedZonesByVPCOperationDeserializer: HttpDeserialize<ListHostedZonesByVpcResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListHostedZonesByVpcResponse {
        if (!response.status.isSuccess()) {
            throwListHostedZonesByVpcError(context, response)
        }
        val builder = ListHostedZonesByVpcResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListHostedZonesByVPCOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListHostedZonesByVpcError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw Route53Exception("Failed to parse response as 'restXml' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidInput" -> InvalidInputDeserializer().deserialize(context, wrappedResponse)
        "InvalidPaginationToken" -> InvalidPaginationTokenDeserializer().deserialize(context, wrappedResponse)
        else -> Route53Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListHostedZonesByVPCOperationBody(builder: ListHostedZonesByVpcResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    val HOSTEDZONESUMMARIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("HostedZoneSummaries"), XmlCollectionName("HostedZoneSummary"))
    val MAXITEMS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, XmlSerialName("MaxItems"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("NextToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlSerialName("ListHostedZonesByVPCResponse"))
        trait(XmlNamespace("https://route53.amazonaws.com/doc/2013-04-01/"))
        field(HOSTEDZONESUMMARIES_DESCRIPTOR)
        field(MAXITEMS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                HOSTEDZONESUMMARIES_DESCRIPTOR.index -> builder.hostedZoneSummaries =
                    deserializer.deserializeList(HOSTEDZONESUMMARIES_DESCRIPTOR) {
                        val col0 = mutableListOf<HostedZoneSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeHostedZoneSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                MAXITEMS_DESCRIPTOR.index -> builder.maxItems = deserializeInt()
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
