// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.route53.model.ListResourceRecordSetsResponse
import aws.sdk.kotlin.services.route53.model.ResourceRecordSet
import aws.sdk.kotlin.services.route53.model.Route53Exception
import aws.sdk.kotlin.services.route53.model.RrType
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlCollectionName
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class ListResourceRecordSetsOperationDeserializer: HttpDeserialize<ListResourceRecordSetsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListResourceRecordSetsResponse {
        if (!response.status.isSuccess()) {
            throwListResourceRecordSetsError(context, response)
        }
        val builder = ListResourceRecordSetsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListResourceRecordSetsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListResourceRecordSetsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw Route53Exception("Failed to parse response as 'restXml' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidInput" -> InvalidInputDeserializer().deserialize(context, wrappedResponse)
        "NoSuchHostedZone" -> NoSuchHostedZoneDeserializer().deserialize(context, wrappedResponse)
        else -> Route53Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListResourceRecordSetsOperationBody(builder: ListResourceRecordSetsResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    val ISTRUNCATED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, XmlSerialName("IsTruncated"))
    val MAXITEMS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, XmlSerialName("MaxItems"))
    val NEXTRECORDIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("NextRecordIdentifier"))
    val NEXTRECORDNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("NextRecordName"))
    val NEXTRECORDTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("NextRecordType"))
    val RESOURCERECORDSETS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("ResourceRecordSets"), XmlCollectionName("ResourceRecordSet"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlSerialName("ListResourceRecordSetsResponse"))
        trait(XmlNamespace("https://route53.amazonaws.com/doc/2013-04-01/"))
        field(ISTRUNCATED_DESCRIPTOR)
        field(MAXITEMS_DESCRIPTOR)
        field(NEXTRECORDIDENTIFIER_DESCRIPTOR)
        field(NEXTRECORDNAME_DESCRIPTOR)
        field(NEXTRECORDTYPE_DESCRIPTOR)
        field(RESOURCERECORDSETS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ISTRUNCATED_DESCRIPTOR.index -> builder.isTruncated = deserializeBoolean()
                MAXITEMS_DESCRIPTOR.index -> builder.maxItems = deserializeInt()
                NEXTRECORDIDENTIFIER_DESCRIPTOR.index -> builder.nextRecordIdentifier = deserializeString()
                NEXTRECORDNAME_DESCRIPTOR.index -> builder.nextRecordName = deserializeString()
                NEXTRECORDTYPE_DESCRIPTOR.index -> builder.nextRecordType = deserializeString().let { RrType.fromValue(it) }
                RESOURCERECORDSETS_DESCRIPTOR.index -> builder.resourceRecordSets =
                    deserializer.deserializeList(RESOURCERECORDSETS_DESCRIPTOR) {
                        val col0 = mutableListOf<ResourceRecordSet>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeResourceRecordSetDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
