// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.route53.model.ListTrafficPolicyInstancesByHostedZoneResponse
import aws.sdk.kotlin.services.route53.model.Route53Exception
import aws.sdk.kotlin.services.route53.model.RrType
import aws.sdk.kotlin.services.route53.model.TrafficPolicyInstance
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlCollectionName
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class ListTrafficPolicyInstancesByHostedZoneOperationDeserializer: HttpDeserialize<ListTrafficPolicyInstancesByHostedZoneResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListTrafficPolicyInstancesByHostedZoneResponse {
        if (!response.status.isSuccess()) {
            throwListTrafficPolicyInstancesByHostedZoneError(context, response)
        }
        val builder = ListTrafficPolicyInstancesByHostedZoneResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListTrafficPolicyInstancesByHostedZoneOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListTrafficPolicyInstancesByHostedZoneError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw Route53Exception("Failed to parse response as 'restXml' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidInput" -> InvalidInputDeserializer().deserialize(context, wrappedResponse)
        "NoSuchHostedZone" -> NoSuchHostedZoneDeserializer().deserialize(context, wrappedResponse)
        "NoSuchTrafficPolicyInstance" -> NoSuchTrafficPolicyInstanceDeserializer().deserialize(context, wrappedResponse)
        else -> Route53Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListTrafficPolicyInstancesByHostedZoneOperationBody(builder: ListTrafficPolicyInstancesByHostedZoneResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    val ISTRUNCATED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, XmlSerialName("IsTruncated"))
    val MAXITEMS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, XmlSerialName("MaxItems"))
    val TRAFFICPOLICYINSTANCENAMEMARKER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("TrafficPolicyInstanceNameMarker"))
    val TRAFFICPOLICYINSTANCETYPEMARKER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("TrafficPolicyInstanceTypeMarker"))
    val TRAFFICPOLICYINSTANCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("TrafficPolicyInstances"), XmlCollectionName("TrafficPolicyInstance"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlSerialName("ListTrafficPolicyInstancesByHostedZoneResponse"))
        trait(XmlNamespace("https://route53.amazonaws.com/doc/2013-04-01/"))
        field(ISTRUNCATED_DESCRIPTOR)
        field(MAXITEMS_DESCRIPTOR)
        field(TRAFFICPOLICYINSTANCENAMEMARKER_DESCRIPTOR)
        field(TRAFFICPOLICYINSTANCETYPEMARKER_DESCRIPTOR)
        field(TRAFFICPOLICYINSTANCES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ISTRUNCATED_DESCRIPTOR.index -> builder.isTruncated = deserializeBoolean()
                MAXITEMS_DESCRIPTOR.index -> builder.maxItems = deserializeInt()
                TRAFFICPOLICYINSTANCENAMEMARKER_DESCRIPTOR.index -> builder.trafficPolicyInstanceNameMarker = deserializeString()
                TRAFFICPOLICYINSTANCETYPEMARKER_DESCRIPTOR.index -> builder.trafficPolicyInstanceTypeMarker = deserializeString().let { RrType.fromValue(it) }
                TRAFFICPOLICYINSTANCES_DESCRIPTOR.index -> builder.trafficPolicyInstances =
                    deserializer.deserializeList(TRAFFICPOLICYINSTANCES_DESCRIPTOR) {
                        val col0 = mutableListOf<TrafficPolicyInstance>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTrafficPolicyInstanceDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
