// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.route53.model.ListVpcAssociationAuthorizationsResponse
import aws.sdk.kotlin.services.route53.model.Route53Exception
import aws.sdk.kotlin.services.route53.model.Vpc
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlCollectionName
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class ListVPCAssociationAuthorizationsOperationDeserializer: HttpDeserialize<ListVpcAssociationAuthorizationsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListVpcAssociationAuthorizationsResponse {
        if (!response.status.isSuccess()) {
            throwListVpcAssociationAuthorizationsError(context, response)
        }
        val builder = ListVpcAssociationAuthorizationsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListVPCAssociationAuthorizationsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListVpcAssociationAuthorizationsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw Route53Exception("Failed to parse response as 'restXml' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidInput" -> InvalidInputDeserializer().deserialize(context, wrappedResponse)
        "InvalidPaginationToken" -> InvalidPaginationTokenDeserializer().deserialize(context, wrappedResponse)
        "NoSuchHostedZone" -> NoSuchHostedZoneDeserializer().deserialize(context, wrappedResponse)
        else -> Route53Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListVPCAssociationAuthorizationsOperationBody(builder: ListVpcAssociationAuthorizationsResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    val HOSTEDZONEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("HostedZoneId"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("NextToken"))
    val VPCS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("VPCs"), XmlCollectionName("VPC"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlSerialName("ListVPCAssociationAuthorizationsResponse"))
        trait(XmlNamespace("https://route53.amazonaws.com/doc/2013-04-01/"))
        field(HOSTEDZONEID_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(VPCS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                HOSTEDZONEID_DESCRIPTOR.index -> builder.hostedZoneId = deserializeString()
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                VPCS_DESCRIPTOR.index -> builder.vpCs =
                    deserializer.deserializeList(VPCS_DESCRIPTOR) {
                        val col0 = mutableListOf<Vpc>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeVpcDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
