// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53.transform

import aws.sdk.kotlin.services.route53.model.AlarmIdentifier
import aws.sdk.kotlin.services.route53.model.HealthCheckRegion
import aws.sdk.kotlin.services.route53.model.InsufficientDataHealthStatus
import aws.sdk.kotlin.services.route53.model.ResettableElementName
import aws.sdk.kotlin.services.route53.model.UpdateHealthCheckRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlCollectionName
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import aws.smithy.kotlin.runtime.serde.xml.XmlSerializer


internal class UpdateHealthCheckOperationSerializer: HttpSerialize<UpdateHealthCheckRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateHealthCheckRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf(
                "2013-04-01",
                "healthcheck",
                "${input.healthCheckId}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeUpdateHealthCheckOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/xml")
        }
        return builder
    }
}

private fun serializeUpdateHealthCheckOperationBody(context: ExecutionContext, input: UpdateHealthCheckRequest): ByteArray {
    val serializer = XmlSerializer()
    val ALARMIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("AlarmIdentifier"))
    val CHILDHEALTHCHECKS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("ChildHealthChecks"), XmlCollectionName("ChildHealthCheck"))
    val DISABLED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, XmlSerialName("Disabled"))
    val ENABLESNI_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, XmlSerialName("EnableSNI"))
    val FAILURETHRESHOLD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, XmlSerialName("FailureThreshold"))
    val FULLYQUALIFIEDDOMAINNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("FullyQualifiedDomainName"))
    val HEALTHCHECKVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, XmlSerialName("HealthCheckVersion"))
    val HEALTHTHRESHOLD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, XmlSerialName("HealthThreshold"))
    val IPADDRESS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("IPAddress"))
    val INSUFFICIENTDATAHEALTHSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("InsufficientDataHealthStatus"))
    val INVERTED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, XmlSerialName("Inverted"))
    val PORT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, XmlSerialName("Port"))
    val REGIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("Regions"), XmlCollectionName("Region"))
    val RESETELEMENTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("ResetElements"), XmlCollectionName("ResettableElementName"))
    val RESOURCEPATH_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("ResourcePath"))
    val SEARCHSTRING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("SearchString"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlSerialName("UpdateHealthCheckRequest"))
        trait(XmlNamespace("https://route53.amazonaws.com/doc/2013-04-01/"))
        field(ALARMIDENTIFIER_DESCRIPTOR)
        field(CHILDHEALTHCHECKS_DESCRIPTOR)
        field(DISABLED_DESCRIPTOR)
        field(ENABLESNI_DESCRIPTOR)
        field(FAILURETHRESHOLD_DESCRIPTOR)
        field(FULLYQUALIFIEDDOMAINNAME_DESCRIPTOR)
        field(HEALTHCHECKVERSION_DESCRIPTOR)
        field(HEALTHTHRESHOLD_DESCRIPTOR)
        field(IPADDRESS_DESCRIPTOR)
        field(INSUFFICIENTDATAHEALTHSTATUS_DESCRIPTOR)
        field(INVERTED_DESCRIPTOR)
        field(PORT_DESCRIPTOR)
        field(REGIONS_DESCRIPTOR)
        field(RESETELEMENTS_DESCRIPTOR)
        field(RESOURCEPATH_DESCRIPTOR)
        field(SEARCHSTRING_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.alarmIdentifier?.let { field(ALARMIDENTIFIER_DESCRIPTOR, it, ::serializeAlarmIdentifierDocument) }
        if (input.childHealthChecks != null) {
            listField(CHILDHEALTHCHECKS_DESCRIPTOR) {
                for (el0 in input.childHealthChecks) {
                    serializeString(el0)
                }
            }
        }
        input.disabled?.let { field(DISABLED_DESCRIPTOR, it) }
        input.enableSni?.let { field(ENABLESNI_DESCRIPTOR, it) }
        input.failureThreshold?.let { field(FAILURETHRESHOLD_DESCRIPTOR, it) }
        input.fullyQualifiedDomainName?.let { field(FULLYQUALIFIEDDOMAINNAME_DESCRIPTOR, it) }
        input.healthCheckVersion?.let { field(HEALTHCHECKVERSION_DESCRIPTOR, it) }
        input.healthThreshold?.let { field(HEALTHTHRESHOLD_DESCRIPTOR, it) }
        input.ipAddress?.let { field(IPADDRESS_DESCRIPTOR, it) }
        input.insufficientDataHealthStatus?.let { field(INSUFFICIENTDATAHEALTHSTATUS_DESCRIPTOR, it.value) }
        input.inverted?.let { field(INVERTED_DESCRIPTOR, it) }
        input.port?.let { field(PORT_DESCRIPTOR, it) }
        if (input.regions != null) {
            listField(REGIONS_DESCRIPTOR) {
                for (el0 in input.regions) {
                    serializeString(el0.value)
                }
            }
        }
        if (input.resetElements != null) {
            listField(RESETELEMENTS_DESCRIPTOR) {
                for (el0 in input.resetElements) {
                    serializeString(el0.value)
                }
            }
        }
        input.resourcePath?.let { field(RESOURCEPATH_DESCRIPTOR, it) }
        input.searchString?.let { field(SEARCHSTRING_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
