// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sfn

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.sfn.endpoints.DefaultEndpointProvider
import aws.sdk.kotlin.services.sfn.endpoints.EndpointProvider
import aws.sdk.kotlin.services.sfn.model.CreateActivityRequest
import aws.sdk.kotlin.services.sfn.model.CreateActivityResponse
import aws.sdk.kotlin.services.sfn.model.CreateStateMachineRequest
import aws.sdk.kotlin.services.sfn.model.CreateStateMachineResponse
import aws.sdk.kotlin.services.sfn.model.DeleteActivityRequest
import aws.sdk.kotlin.services.sfn.model.DeleteActivityResponse
import aws.sdk.kotlin.services.sfn.model.DeleteStateMachineRequest
import aws.sdk.kotlin.services.sfn.model.DeleteStateMachineResponse
import aws.sdk.kotlin.services.sfn.model.DescribeActivityRequest
import aws.sdk.kotlin.services.sfn.model.DescribeActivityResponse
import aws.sdk.kotlin.services.sfn.model.DescribeExecutionRequest
import aws.sdk.kotlin.services.sfn.model.DescribeExecutionResponse
import aws.sdk.kotlin.services.sfn.model.DescribeMapRunRequest
import aws.sdk.kotlin.services.sfn.model.DescribeMapRunResponse
import aws.sdk.kotlin.services.sfn.model.DescribeStateMachineForExecutionRequest
import aws.sdk.kotlin.services.sfn.model.DescribeStateMachineForExecutionResponse
import aws.sdk.kotlin.services.sfn.model.DescribeStateMachineRequest
import aws.sdk.kotlin.services.sfn.model.DescribeStateMachineResponse
import aws.sdk.kotlin.services.sfn.model.GetActivityTaskRequest
import aws.sdk.kotlin.services.sfn.model.GetActivityTaskResponse
import aws.sdk.kotlin.services.sfn.model.GetExecutionHistoryRequest
import aws.sdk.kotlin.services.sfn.model.GetExecutionHistoryResponse
import aws.sdk.kotlin.services.sfn.model.ListActivitiesRequest
import aws.sdk.kotlin.services.sfn.model.ListActivitiesResponse
import aws.sdk.kotlin.services.sfn.model.ListExecutionsRequest
import aws.sdk.kotlin.services.sfn.model.ListExecutionsResponse
import aws.sdk.kotlin.services.sfn.model.ListMapRunsRequest
import aws.sdk.kotlin.services.sfn.model.ListMapRunsResponse
import aws.sdk.kotlin.services.sfn.model.ListStateMachinesRequest
import aws.sdk.kotlin.services.sfn.model.ListStateMachinesResponse
import aws.sdk.kotlin.services.sfn.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.sfn.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.sfn.model.SendTaskFailureRequest
import aws.sdk.kotlin.services.sfn.model.SendTaskFailureResponse
import aws.sdk.kotlin.services.sfn.model.SendTaskHeartbeatRequest
import aws.sdk.kotlin.services.sfn.model.SendTaskHeartbeatResponse
import aws.sdk.kotlin.services.sfn.model.SendTaskSuccessRequest
import aws.sdk.kotlin.services.sfn.model.SendTaskSuccessResponse
import aws.sdk.kotlin.services.sfn.model.StartExecutionRequest
import aws.sdk.kotlin.services.sfn.model.StartExecutionResponse
import aws.sdk.kotlin.services.sfn.model.StartSyncExecutionRequest
import aws.sdk.kotlin.services.sfn.model.StartSyncExecutionResponse
import aws.sdk.kotlin.services.sfn.model.StopExecutionRequest
import aws.sdk.kotlin.services.sfn.model.StopExecutionResponse
import aws.sdk.kotlin.services.sfn.model.TagResourceRequest
import aws.sdk.kotlin.services.sfn.model.TagResourceResponse
import aws.sdk.kotlin.services.sfn.model.UntagResourceRequest
import aws.sdk.kotlin.services.sfn.model.UntagResourceResponse
import aws.sdk.kotlin.services.sfn.model.UpdateMapRunRequest
import aws.sdk.kotlin.services.sfn.model.UpdateMapRunResponse
import aws.sdk.kotlin.services.sfn.model.UpdateStateMachineRequest
import aws.sdk.kotlin.services.sfn.model.UpdateStateMachineResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.internal.manage
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.tracing.DefaultTracer
import aws.smithy.kotlin.runtime.tracing.LoggingTraceProbe
import aws.smithy.kotlin.runtime.tracing.Tracer
import aws.smithy.kotlin.runtime.tracing.TracingClientConfig
import kotlin.collections.List
import kotlin.jvm.JvmStatic

/**
 * # Step Functions
 * Step Functions is a service that lets you coordinate the components of distributed applications and microservices using visual workflows.
 *
 * You can use Step Functions to build applications from individual components, each of which performs a discrete function, or *task*, allowing you to scale and change applications quickly. Step Functions provides a console that helps visualize the components of your application as a series of steps. Step Functions automatically triggers and tracks each step, and retries steps when there are errors, so your application executes predictably and in the right order every time. Step Functions logs the state of each step, so you can quickly diagnose and debug any issues.
 *
 * Step Functions manages operations and underlying infrastructure to ensure your application is available at any scale. You can run tasks on Amazon Web Services, your own servers, or any system that has access to Amazon Web Services. You can access and use Step Functions using the console, the Amazon Web Services SDKs, or an HTTP API. For more information about Step Functions, see the *[Step Functions Developer Guide](https://docs.aws.amazon.com/step-functions/latest/dg/welcome.html)*.
 */
public interface SfnClient : SdkClient {

    override val serviceName: String
        get() = "SFN"
    /**
     * SfnClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, SfnClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, SfnClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): SfnClient = DefaultSfnClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, HttpClientConfig, SdkClientConfig, TracingClientConfig {
        override val httpClientEngine: HttpClientEngine = builder.httpClientEngine ?: DefaultHttpEngine().manage()
        override val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region).manage()
        public val endpointProvider: EndpointProvider = builder.endpointProvider ?: DefaultEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsDefaultRetryPolicy
        override val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        override val tracer: Tracer = builder.tracer ?: DefaultTracer(LoggingTraceProbe, "SFN")
        public val useDualStack: Boolean = builder.useDualStack
        public val useFips: Boolean = builder.useFips
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            httpClientEngine = this@Config.httpClientEngine
            region = this@Config.region
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            interceptors = this@Config.interceptors.toMutableList()
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            sdkLogMode = this@Config.sdkLogMode
            signer = this@Config.signer
            tracer = this@Config.tracer
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
        }

        public class Builder : AwsSdkClientConfig.Builder, HttpClientConfig.Builder, SdkClientConfig.Builder<Config>, TracingClientConfig.Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            override var httpClientEngine: HttpClientEngine? = null

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests.
             */
            public var endpointProvider: EndpointProvider? = null

            /**
             * A custom endpoint to use when making requests.
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            override var retryStrategy: RetryStrategy? = null

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var sdkLogMode: SdkLogMode = SdkLogMode.Default

            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            /**
             * The tracer that is responsible for creating trace spans and wiring them up to a tracing backend (e.g.,
             * a trace probe). By default, this will create a standard tracer that uses the service name for the root
             * trace span and delegates to a logging trace probe (i.e.,
             * `DefaultTracer(LoggingTraceProbe, "<service-name>")`).
             */
            override var tracer: Tracer? = null

            /**
             * Flag to toggle whether to use dual-stack endpoints when making requests.
             */
            public var useDualStack: Boolean = false

            /**
             * Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             */
            public var useFips: Boolean = false

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Creates an activity. An activity is a task that you write in any programming language and host on any machine that has access to Step Functions. Activities must poll Step Functions using the `GetActivityTask` API action and respond using `SendTask*` API actions. This function lets Step Functions know the existence of your activity and returns an identifier for use in a state machine and when polling from the activity.
     *
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.
     *
     * `CreateActivity` is an idempotent API. Subsequent requests won’t create a duplicate resource if it was already created. `CreateActivity`'s idempotency check is based on the activity `name`. If a following request has different `tags` values, Step Functions will ignore these differences and treat it as an idempotent request of the previous. In this case, `tags` will not be updated, even if they are different.
     */
    public suspend fun createActivity(input: CreateActivityRequest): CreateActivityResponse

    /**
     * Creates a state machine. A state machine consists of a collection of states that can do work (`Task` states), determine to which states to transition next (`Choice` states), stop an execution with an error (`Fail` states), and so on. State machines are specified using a JSON-based, structured language. For more information, see [Amazon States Language](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html) in the Step Functions User Guide.
     *
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.
     *
     * `CreateStateMachine` is an idempotent API. Subsequent requests won’t create a duplicate resource if it was already created. `CreateStateMachine`'s idempotency check is based on the state machine `name`, `definition`, `type`, `LoggingConfiguration` and `TracingConfiguration`. If a following request has a different `roleArn` or `tags`, Step Functions will ignore these differences and treat it as an idempotent request of the previous. In this case, `roleArn` and `tags` will not be updated, even if they are different.
     */
    public suspend fun createStateMachine(input: CreateStateMachineRequest): CreateStateMachineResponse

    /**
     * Deletes an activity.
     */
    public suspend fun deleteActivity(input: DeleteActivityRequest): DeleteActivityResponse

    /**
     * Deletes a state machine. This is an asynchronous operation: It sets the state machine's status to `DELETING` and begins the deletion process.
     *
     * If the given state machine Amazon Resource Name (ARN) is a qualified state machine ARN, it will fail with ValidationException.
     *
     * A qualified state machine ARN refers to a *Distributed Map state* defined within a state machine. For example, the qualified state machine ARN `arn:partition:states:region:account-id:stateMachine:stateMachineName/mapStateLabel` refers to a *Distributed Map state* with a label `mapStateLabel` in the state machine named `stateMachineName`.
     *
     * For `EXPRESS` state machines, the deletion will happen eventually (usually less than a minute). Running executions may emit logs after `DeleteStateMachine` API is called.
     */
    public suspend fun deleteStateMachine(input: DeleteStateMachineRequest): DeleteStateMachineResponse

    /**
     * Describes an activity.
     *
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.
     */
    public suspend fun describeActivity(input: DescribeActivityRequest): DescribeActivityResponse

    /**
     * Provides all information about a state machine execution, such as the state machine associated with the execution, the execution input and output, and relevant execution metadata. Use this API action to return the Map Run ARN if the execution was dispatched by a Map Run.
     *
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.
     *
     * This API action is not supported by `EXPRESS` state machine executions unless they were dispatched by a Map Run.
     */
    public suspend fun describeExecution(input: DescribeExecutionRequest): DescribeExecutionResponse

    /**
     * Provides information about a Map Run's configuration, progress, and results. For more information, see [Examining Map Run](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-examine-map-run.html) in the *Step Functions Developer Guide*.
     */
    public suspend fun describeMapRun(input: DescribeMapRunRequest): DescribeMapRunResponse

    /**
     * Provides information about a state machine's definition, its IAM role Amazon Resource Name (ARN), and configuration. If the state machine ARN is a qualified state machine ARN, the response returned includes the `Map` state's label.
     *
     * A qualified state machine ARN refers to a *Distributed Map state* defined within a state machine. For example, the qualified state machine ARN `arn:partition:states:region:account-id:stateMachine:stateMachineName/mapStateLabel` refers to a *Distributed Map state* with a label `mapStateLabel` in the state machine named `stateMachineName`.
     *
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.
     */
    public suspend fun describeStateMachine(input: DescribeStateMachineRequest): DescribeStateMachineResponse

    /**
     * Provides information about a state machine's definition, its execution role ARN, and configuration. If an execution was dispatched by a Map Run, the Map Run is returned in the response. Additionally, the state machine returned will be the state machine associated with the Map Run.
     *
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.
     *
     * This API action is not supported by `EXPRESS` state machines.
     */
    public suspend fun describeStateMachineForExecution(input: DescribeStateMachineForExecutionRequest): DescribeStateMachineForExecutionResponse

    /**
     * Used by workers to retrieve a task (with the specified activity ARN) which has been scheduled for execution by a running state machine. This initiates a long poll, where the service holds the HTTP connection open and responds as soon as a task becomes available (i.e. an execution of a task of this type is needed.) The maximum time the service holds on to the request before responding is 60 seconds. If no task is available within 60 seconds, the poll returns a `taskToken` with a null string.
     *
     * This API action isn't logged in CloudTrail.
     *
     * Workers should set their client side socket timeout to at least 65 seconds (5 seconds higher than the maximum time the service may hold the poll request).
     *
     * Polling with `GetActivityTask` can cause latency in some implementations. See [Avoid Latency When Polling for Activity Tasks](https://docs.aws.amazon.com/step-functions/latest/dg/bp-activity-pollers.html) in the Step Functions Developer Guide.
     */
    public suspend fun getActivityTask(input: GetActivityTaskRequest): GetActivityTaskResponse

    /**
     * Returns the history of the specified execution as a list of events. By default, the results are returned in ascending order of the `timeStamp` of the events. Use the `reverseOrder` parameter to get the latest events first.
     *
     * If `nextToken` is returned, there are more results available. The value of `nextToken` is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an *HTTP 400 InvalidToken* error.
     *
     * This API action is not supported by `EXPRESS` state machines.
     */
    public suspend fun getExecutionHistory(input: GetExecutionHistoryRequest): GetExecutionHistoryResponse

    /**
     * Lists the existing activities.
     *
     * If `nextToken` is returned, there are more results available. The value of `nextToken` is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an *HTTP 400 InvalidToken* error.
     *
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.
     */
    public suspend fun listActivities(input: ListActivitiesRequest = ListActivitiesRequest {}): ListActivitiesResponse

    /**
     * Lists all executions of a state machine or a Map Run. You can list all executions related to a state machine by specifying a state machine Amazon Resource Name (ARN), or those related to a Map Run by specifying a Map Run ARN.
     *
     * Results are sorted by time, with the most recent execution first.
     *
     * If `nextToken` is returned, there are more results available. The value of `nextToken` is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an *HTTP 400 InvalidToken* error.
     *
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.
     *
     * This API action is not supported by `EXPRESS` state machines.
     */
    public suspend fun listExecutions(input: ListExecutionsRequest = ListExecutionsRequest {}): ListExecutionsResponse

    /**
     * Lists all Map Runs that were started by a given state machine execution. Use this API action to obtain Map Run ARNs, and then call `DescribeMapRun` to obtain more information, if needed.
     */
    public suspend fun listMapRuns(input: ListMapRunsRequest): ListMapRunsResponse

    /**
     * Lists the existing state machines.
     *
     * If `nextToken` is returned, there are more results available. The value of `nextToken` is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an *HTTP 400 InvalidToken* error.
     *
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.
     */
    public suspend fun listStateMachines(input: ListStateMachinesRequest = ListStateMachinesRequest {}): ListStateMachinesResponse

    /**
     * List tags for a given resource.
     *
     * Tags may only contain Unicode letters, digits, white space, or these symbols: `_ . : / = + - @`.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Used by activity workers and task states using the [callback](https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token) pattern to report that the task identified by the `taskToken` failed.
     */
    public suspend fun sendTaskFailure(input: SendTaskFailureRequest): SendTaskFailureResponse

    /**
     * Used by activity workers and task states using the [callback](https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token) pattern to report to Step Functions that the task represented by the specified `taskToken` is still making progress. This action resets the `Heartbeat` clock. The `Heartbeat` threshold is specified in the state machine's Amazon States Language definition (`HeartbeatSeconds`). This action does not in itself create an event in the execution history. However, if the task times out, the execution history contains an `ActivityTimedOut` entry for activities, or a `TaskTimedOut` entry for for tasks using the [job run](https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-sync) or [callback](https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token) pattern.
     *
     * The `Timeout` of a task, defined in the state machine's Amazon States Language definition, is its maximum allowed duration, regardless of the number of SendTaskHeartbeat requests received. Use `HeartbeatSeconds` to configure the timeout interval for heartbeats.
     */
    public suspend fun sendTaskHeartbeat(input: SendTaskHeartbeatRequest): SendTaskHeartbeatResponse

    /**
     * Used by activity workers and task states using the [callback](https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token) pattern to report that the task identified by the `taskToken` completed successfully.
     */
    public suspend fun sendTaskSuccess(input: SendTaskSuccessRequest): SendTaskSuccessResponse

    /**
     * Starts a state machine execution. If the given state machine Amazon Resource Name (ARN) is a qualified state machine ARN, it will fail with ValidationException.
     *
     * A qualified state machine ARN refers to a *Distributed Map state* defined within a state machine. For example, the qualified state machine ARN `arn:partition:states:region:account-id:stateMachine:stateMachineName/mapStateLabel` refers to a *Distributed Map state* with a label `mapStateLabel` in the state machine named `stateMachineName`.
     *
     * `StartExecution` is idempotent for `STANDARD` workflows. For a `STANDARD` workflow, if `StartExecution` is called with the same name and input as a running execution, the call will succeed and return the same response as the original request. If the execution is closed or if the input is different, it will return a `400 ExecutionAlreadyExists` error. Names can be reused after 90 days.
     *
     * `StartExecution` is not idempotent for `EXPRESS` workflows.
     */
    public suspend fun startExecution(input: StartExecutionRequest): StartExecutionResponse

    /**
     * Starts a Synchronous Express state machine execution. `StartSyncExecution` is not available for `STANDARD` workflows.
     *
     * `StartSyncExecution` will return a `200 OK` response, even if your execution fails, because the status code in the API response doesn't reflect function errors. Error codes are reserved for errors that prevent your execution from running, such as permissions errors, limit errors, or issues with your state machine code and configuration.
     *
     * This API action isn't logged in CloudTrail.
     */
    public suspend fun startSyncExecution(input: StartSyncExecutionRequest): StartSyncExecutionResponse

    /**
     * Stops an execution.
     *
     * This API action is not supported by `EXPRESS` state machines.
     */
    public suspend fun stopExecution(input: StopExecutionRequest): StopExecutionResponse

    /**
     * Add a tag to a Step Functions resource.
     *
     * An array of key-value pairs. For more information, see [Using Cost Allocation Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html) in the *Amazon Web Services Billing and Cost Management User Guide*, and [Controlling Access Using IAM Tags](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html).
     *
     * Tags may only contain Unicode letters, digits, white space, or these symbols: `_ . : / = + - @`.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Remove a tag from a Step Functions resource
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates an in-progress Map Run's configuration to include changes to the settings that control maximum concurrency and Map Run failure.
     */
    public suspend fun updateMapRun(input: UpdateMapRunRequest): UpdateMapRunResponse

    /**
     * Updates an existing state machine by modifying its `definition`, `roleArn`, or `loggingConfiguration`. Running executions will continue to use the previous `definition` and `roleArn`. You must include at least one of `definition` or `roleArn` or you will receive a `MissingRequiredParameter` error.
     *
     * If the given state machine Amazon Resource Name (ARN) is a qualified state machine ARN, it will fail with ValidationException.
     *
     * A qualified state machine ARN refers to a *Distributed Map state* defined within a state machine. For example, the qualified state machine ARN `arn:partition:states:region:account-id:stateMachine:stateMachineName/mapStateLabel` refers to a *Distributed Map state* with a label `mapStateLabel` in the state machine named `stateMachineName`.
     *
     * All `StartExecution` calls within a few seconds will use the updated `definition` and `roleArn`. Executions started immediately after calling `UpdateStateMachine` may use the previous state machine `definition` and `roleArn`.
     */
    public suspend fun updateStateMachine(input: UpdateStateMachineRequest): UpdateStateMachineResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun SfnClient.withConfig(block: SfnClient.Config.Builder.() -> Unit): SfnClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultSfnClient(newConfig)
}

/**
 * Creates an activity. An activity is a task that you write in any programming language and host on any machine that has access to Step Functions. Activities must poll Step Functions using the `GetActivityTask` API action and respond using `SendTask*` API actions. This function lets Step Functions know the existence of your activity and returns an identifier for use in a state machine and when polling from the activity.
 *
 * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.
 *
 * `CreateActivity` is an idempotent API. Subsequent requests won’t create a duplicate resource if it was already created. `CreateActivity`'s idempotency check is based on the activity `name`. If a following request has different `tags` values, Step Functions will ignore these differences and treat it as an idempotent request of the previous. In this case, `tags` will not be updated, even if they are different.
 */
public suspend inline fun SfnClient.createActivity(crossinline block: CreateActivityRequest.Builder.() -> Unit): CreateActivityResponse = createActivity(CreateActivityRequest.Builder().apply(block).build())

/**
 * Creates a state machine. A state machine consists of a collection of states that can do work (`Task` states), determine to which states to transition next (`Choice` states), stop an execution with an error (`Fail` states), and so on. State machines are specified using a JSON-based, structured language. For more information, see [Amazon States Language](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html) in the Step Functions User Guide.
 *
 * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.
 *
 * `CreateStateMachine` is an idempotent API. Subsequent requests won’t create a duplicate resource if it was already created. `CreateStateMachine`'s idempotency check is based on the state machine `name`, `definition`, `type`, `LoggingConfiguration` and `TracingConfiguration`. If a following request has a different `roleArn` or `tags`, Step Functions will ignore these differences and treat it as an idempotent request of the previous. In this case, `roleArn` and `tags` will not be updated, even if they are different.
 */
public suspend inline fun SfnClient.createStateMachine(crossinline block: CreateStateMachineRequest.Builder.() -> Unit): CreateStateMachineResponse = createStateMachine(CreateStateMachineRequest.Builder().apply(block).build())

/**
 * Deletes an activity.
 */
public suspend inline fun SfnClient.deleteActivity(crossinline block: DeleteActivityRequest.Builder.() -> Unit): DeleteActivityResponse = deleteActivity(DeleteActivityRequest.Builder().apply(block).build())

/**
 * Deletes a state machine. This is an asynchronous operation: It sets the state machine's status to `DELETING` and begins the deletion process.
 *
 * If the given state machine Amazon Resource Name (ARN) is a qualified state machine ARN, it will fail with ValidationException.
 *
 * A qualified state machine ARN refers to a *Distributed Map state* defined within a state machine. For example, the qualified state machine ARN `arn:partition:states:region:account-id:stateMachine:stateMachineName/mapStateLabel` refers to a *Distributed Map state* with a label `mapStateLabel` in the state machine named `stateMachineName`.
 *
 * For `EXPRESS` state machines, the deletion will happen eventually (usually less than a minute). Running executions may emit logs after `DeleteStateMachine` API is called.
 */
public suspend inline fun SfnClient.deleteStateMachine(crossinline block: DeleteStateMachineRequest.Builder.() -> Unit): DeleteStateMachineResponse = deleteStateMachine(DeleteStateMachineRequest.Builder().apply(block).build())

/**
 * Describes an activity.
 *
 * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.
 */
public suspend inline fun SfnClient.describeActivity(crossinline block: DescribeActivityRequest.Builder.() -> Unit): DescribeActivityResponse = describeActivity(DescribeActivityRequest.Builder().apply(block).build())

/**
 * Provides all information about a state machine execution, such as the state machine associated with the execution, the execution input and output, and relevant execution metadata. Use this API action to return the Map Run ARN if the execution was dispatched by a Map Run.
 *
 * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.
 *
 * This API action is not supported by `EXPRESS` state machine executions unless they were dispatched by a Map Run.
 */
public suspend inline fun SfnClient.describeExecution(crossinline block: DescribeExecutionRequest.Builder.() -> Unit): DescribeExecutionResponse = describeExecution(DescribeExecutionRequest.Builder().apply(block).build())

/**
 * Provides information about a Map Run's configuration, progress, and results. For more information, see [Examining Map Run](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-examine-map-run.html) in the *Step Functions Developer Guide*.
 */
public suspend inline fun SfnClient.describeMapRun(crossinline block: DescribeMapRunRequest.Builder.() -> Unit): DescribeMapRunResponse = describeMapRun(DescribeMapRunRequest.Builder().apply(block).build())

/**
 * Provides information about a state machine's definition, its IAM role Amazon Resource Name (ARN), and configuration. If the state machine ARN is a qualified state machine ARN, the response returned includes the `Map` state's label.
 *
 * A qualified state machine ARN refers to a *Distributed Map state* defined within a state machine. For example, the qualified state machine ARN `arn:partition:states:region:account-id:stateMachine:stateMachineName/mapStateLabel` refers to a *Distributed Map state* with a label `mapStateLabel` in the state machine named `stateMachineName`.
 *
 * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.
 */
public suspend inline fun SfnClient.describeStateMachine(crossinline block: DescribeStateMachineRequest.Builder.() -> Unit): DescribeStateMachineResponse = describeStateMachine(DescribeStateMachineRequest.Builder().apply(block).build())

/**
 * Provides information about a state machine's definition, its execution role ARN, and configuration. If an execution was dispatched by a Map Run, the Map Run is returned in the response. Additionally, the state machine returned will be the state machine associated with the Map Run.
 *
 * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.
 *
 * This API action is not supported by `EXPRESS` state machines.
 */
public suspend inline fun SfnClient.describeStateMachineForExecution(crossinline block: DescribeStateMachineForExecutionRequest.Builder.() -> Unit): DescribeStateMachineForExecutionResponse = describeStateMachineForExecution(DescribeStateMachineForExecutionRequest.Builder().apply(block).build())

/**
 * Used by workers to retrieve a task (with the specified activity ARN) which has been scheduled for execution by a running state machine. This initiates a long poll, where the service holds the HTTP connection open and responds as soon as a task becomes available (i.e. an execution of a task of this type is needed.) The maximum time the service holds on to the request before responding is 60 seconds. If no task is available within 60 seconds, the poll returns a `taskToken` with a null string.
 *
 * This API action isn't logged in CloudTrail.
 *
 * Workers should set their client side socket timeout to at least 65 seconds (5 seconds higher than the maximum time the service may hold the poll request).
 *
 * Polling with `GetActivityTask` can cause latency in some implementations. See [Avoid Latency When Polling for Activity Tasks](https://docs.aws.amazon.com/step-functions/latest/dg/bp-activity-pollers.html) in the Step Functions Developer Guide.
 */
public suspend inline fun SfnClient.getActivityTask(crossinline block: GetActivityTaskRequest.Builder.() -> Unit): GetActivityTaskResponse = getActivityTask(GetActivityTaskRequest.Builder().apply(block).build())

/**
 * Returns the history of the specified execution as a list of events. By default, the results are returned in ascending order of the `timeStamp` of the events. Use the `reverseOrder` parameter to get the latest events first.
 *
 * If `nextToken` is returned, there are more results available. The value of `nextToken` is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an *HTTP 400 InvalidToken* error.
 *
 * This API action is not supported by `EXPRESS` state machines.
 */
public suspend inline fun SfnClient.getExecutionHistory(crossinline block: GetExecutionHistoryRequest.Builder.() -> Unit): GetExecutionHistoryResponse = getExecutionHistory(GetExecutionHistoryRequest.Builder().apply(block).build())

/**
 * Lists the existing activities.
 *
 * If `nextToken` is returned, there are more results available. The value of `nextToken` is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an *HTTP 400 InvalidToken* error.
 *
 * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.
 */
public suspend inline fun SfnClient.listActivities(crossinline block: ListActivitiesRequest.Builder.() -> Unit): ListActivitiesResponse = listActivities(ListActivitiesRequest.Builder().apply(block).build())

/**
 * Lists all executions of a state machine or a Map Run. You can list all executions related to a state machine by specifying a state machine Amazon Resource Name (ARN), or those related to a Map Run by specifying a Map Run ARN.
 *
 * Results are sorted by time, with the most recent execution first.
 *
 * If `nextToken` is returned, there are more results available. The value of `nextToken` is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an *HTTP 400 InvalidToken* error.
 *
 * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.
 *
 * This API action is not supported by `EXPRESS` state machines.
 */
public suspend inline fun SfnClient.listExecutions(crossinline block: ListExecutionsRequest.Builder.() -> Unit): ListExecutionsResponse = listExecutions(ListExecutionsRequest.Builder().apply(block).build())

/**
 * Lists all Map Runs that were started by a given state machine execution. Use this API action to obtain Map Run ARNs, and then call `DescribeMapRun` to obtain more information, if needed.
 */
public suspend inline fun SfnClient.listMapRuns(crossinline block: ListMapRunsRequest.Builder.() -> Unit): ListMapRunsResponse = listMapRuns(ListMapRunsRequest.Builder().apply(block).build())

/**
 * Lists the existing state machines.
 *
 * If `nextToken` is returned, there are more results available. The value of `nextToken` is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an *HTTP 400 InvalidToken* error.
 *
 * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.
 */
public suspend inline fun SfnClient.listStateMachines(crossinline block: ListStateMachinesRequest.Builder.() -> Unit): ListStateMachinesResponse = listStateMachines(ListStateMachinesRequest.Builder().apply(block).build())

/**
 * List tags for a given resource.
 *
 * Tags may only contain Unicode letters, digits, white space, or these symbols: `_ . : / = + - @`.
 */
public suspend inline fun SfnClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Used by activity workers and task states using the [callback](https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token) pattern to report that the task identified by the `taskToken` failed.
 */
public suspend inline fun SfnClient.sendTaskFailure(crossinline block: SendTaskFailureRequest.Builder.() -> Unit): SendTaskFailureResponse = sendTaskFailure(SendTaskFailureRequest.Builder().apply(block).build())

/**
 * Used by activity workers and task states using the [callback](https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token) pattern to report to Step Functions that the task represented by the specified `taskToken` is still making progress. This action resets the `Heartbeat` clock. The `Heartbeat` threshold is specified in the state machine's Amazon States Language definition (`HeartbeatSeconds`). This action does not in itself create an event in the execution history. However, if the task times out, the execution history contains an `ActivityTimedOut` entry for activities, or a `TaskTimedOut` entry for for tasks using the [job run](https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-sync) or [callback](https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token) pattern.
 *
 * The `Timeout` of a task, defined in the state machine's Amazon States Language definition, is its maximum allowed duration, regardless of the number of SendTaskHeartbeat requests received. Use `HeartbeatSeconds` to configure the timeout interval for heartbeats.
 */
public suspend inline fun SfnClient.sendTaskHeartbeat(crossinline block: SendTaskHeartbeatRequest.Builder.() -> Unit): SendTaskHeartbeatResponse = sendTaskHeartbeat(SendTaskHeartbeatRequest.Builder().apply(block).build())

/**
 * Used by activity workers and task states using the [callback](https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token) pattern to report that the task identified by the `taskToken` completed successfully.
 */
public suspend inline fun SfnClient.sendTaskSuccess(crossinline block: SendTaskSuccessRequest.Builder.() -> Unit): SendTaskSuccessResponse = sendTaskSuccess(SendTaskSuccessRequest.Builder().apply(block).build())

/**
 * Starts a state machine execution. If the given state machine Amazon Resource Name (ARN) is a qualified state machine ARN, it will fail with ValidationException.
 *
 * A qualified state machine ARN refers to a *Distributed Map state* defined within a state machine. For example, the qualified state machine ARN `arn:partition:states:region:account-id:stateMachine:stateMachineName/mapStateLabel` refers to a *Distributed Map state* with a label `mapStateLabel` in the state machine named `stateMachineName`.
 *
 * `StartExecution` is idempotent for `STANDARD` workflows. For a `STANDARD` workflow, if `StartExecution` is called with the same name and input as a running execution, the call will succeed and return the same response as the original request. If the execution is closed or if the input is different, it will return a `400 ExecutionAlreadyExists` error. Names can be reused after 90 days.
 *
 * `StartExecution` is not idempotent for `EXPRESS` workflows.
 */
public suspend inline fun SfnClient.startExecution(crossinline block: StartExecutionRequest.Builder.() -> Unit): StartExecutionResponse = startExecution(StartExecutionRequest.Builder().apply(block).build())

/**
 * Starts a Synchronous Express state machine execution. `StartSyncExecution` is not available for `STANDARD` workflows.
 *
 * `StartSyncExecution` will return a `200 OK` response, even if your execution fails, because the status code in the API response doesn't reflect function errors. Error codes are reserved for errors that prevent your execution from running, such as permissions errors, limit errors, or issues with your state machine code and configuration.
 *
 * This API action isn't logged in CloudTrail.
 */
public suspend inline fun SfnClient.startSyncExecution(crossinline block: StartSyncExecutionRequest.Builder.() -> Unit): StartSyncExecutionResponse = startSyncExecution(StartSyncExecutionRequest.Builder().apply(block).build())

/**
 * Stops an execution.
 *
 * This API action is not supported by `EXPRESS` state machines.
 */
public suspend inline fun SfnClient.stopExecution(crossinline block: StopExecutionRequest.Builder.() -> Unit): StopExecutionResponse = stopExecution(StopExecutionRequest.Builder().apply(block).build())

/**
 * Add a tag to a Step Functions resource.
 *
 * An array of key-value pairs. For more information, see [Using Cost Allocation Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html) in the *Amazon Web Services Billing and Cost Management User Guide*, and [Controlling Access Using IAM Tags](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html).
 *
 * Tags may only contain Unicode letters, digits, white space, or these symbols: `_ . : / = + - @`.
 */
public suspend inline fun SfnClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Remove a tag from a Step Functions resource
 */
public suspend inline fun SfnClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates an in-progress Map Run's configuration to include changes to the settings that control maximum concurrency and Map Run failure.
 */
public suspend inline fun SfnClient.updateMapRun(crossinline block: UpdateMapRunRequest.Builder.() -> Unit): UpdateMapRunResponse = updateMapRun(UpdateMapRunRequest.Builder().apply(block).build())

/**
 * Updates an existing state machine by modifying its `definition`, `roleArn`, or `loggingConfiguration`. Running executions will continue to use the previous `definition` and `roleArn`. You must include at least one of `definition` or `roleArn` or you will receive a `MissingRequiredParameter` error.
 *
 * If the given state machine Amazon Resource Name (ARN) is a qualified state machine ARN, it will fail with ValidationException.
 *
 * A qualified state machine ARN refers to a *Distributed Map state* defined within a state machine. For example, the qualified state machine ARN `arn:partition:states:region:account-id:stateMachine:stateMachineName/mapStateLabel` refers to a *Distributed Map state* with a label `mapStateLabel` in the state machine named `stateMachineName`.
 *
 * All `StartExecution` calls within a few seconds will use the updated `definition` and `roleArn`. Executions started immediately after calling `UpdateStateMachine` may use the previous state machine `definition` and `roleArn`.
 */
public suspend inline fun SfnClient.updateStateMachine(crossinline block: UpdateStateMachineRequest.Builder.() -> Unit): UpdateStateMachineResponse = updateStateMachine(UpdateStateMachineRequest.Builder().apply(block).build())
