// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sfn.model



public class CreateStateMachineRequest private constructor(builder: Builder) {
    /**
     * The Amazon States Language definition of the state machine. See [Amazon States Language](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html).
     */
    public val definition: kotlin.String? = builder.definition
    /**
     * Defines what execution history events are logged and where they are logged.
     *
     * By default, the `level` is set to `OFF`. For more information see [Log Levels](https://docs.aws.amazon.com/step-functions/latest/dg/cloudwatch-log-level.html) in the Step Functions User Guide.
     */
    public val loggingConfiguration: aws.sdk.kotlin.services.sfn.model.LoggingConfiguration? = builder.loggingConfiguration
    /**
     * The name of the state machine.
     *
     * A name must *not* contain:
     * + white space
     * + brackets `< > { } [ ]`
     * + wildcard characters `? *`
     * + special characters `" # % \ ^ | ~ ` $ & , ; : /`
     * + control characters (`U+0000-001F`, `U+007F-009F`)
     *
     * To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Amazon Resource Name (ARN) of the IAM role to use for this state machine.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * Tags to be added when creating a state machine.
     *
     * An array of key-value pairs. For more information, see [Using Cost Allocation Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html) in the *Amazon Web Services Billing and Cost Management User Guide*, and [Controlling Access Using IAM Tags](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html).
     *
     * Tags may only contain Unicode letters, digits, white space, or these symbols: `_ . : / = + - @`.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * Selects whether X-Ray tracing is enabled.
     */
    public val tracingConfiguration: aws.sdk.kotlin.services.sfn.model.TracingConfiguration? = builder.tracingConfiguration
    /**
     * Determines whether a Standard or Express state machine is created. The default is `STANDARD`. You cannot update the `type` of a state machine once it has been created.
     */
    public val type: aws.sdk.kotlin.services.sfn.model.StateMachineType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sfn.model.CreateStateMachineRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateStateMachineRequest(")
        append("definition=*** Sensitive Data Redacted ***,")
        append("loggingConfiguration=$loggingConfiguration,")
        append("name=$name,")
        append("roleArn=$roleArn,")
        append("tags=$tags,")
        append("tracingConfiguration=$tracingConfiguration,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = definition?.hashCode() ?: 0
        result = 31 * result + (loggingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (tracingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateStateMachineRequest

        if (definition != other.definition) return false
        if (loggingConfiguration != other.loggingConfiguration) return false
        if (name != other.name) return false
        if (roleArn != other.roleArn) return false
        if (tags != other.tags) return false
        if (tracingConfiguration != other.tracingConfiguration) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sfn.model.CreateStateMachineRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon States Language definition of the state machine. See [Amazon States Language](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html).
         */
        public var definition: kotlin.String? = null
        /**
         * Defines what execution history events are logged and where they are logged.
         *
         * By default, the `level` is set to `OFF`. For more information see [Log Levels](https://docs.aws.amazon.com/step-functions/latest/dg/cloudwatch-log-level.html) in the Step Functions User Guide.
         */
        public var loggingConfiguration: aws.sdk.kotlin.services.sfn.model.LoggingConfiguration? = null
        /**
         * The name of the state machine.
         *
         * A name must *not* contain:
         * + white space
         * + brackets `< > { } [ ]`
         * + wildcard characters `? *`
         * + special characters `" # % \ ^ | ~ ` $ & , ; : /`
         * + control characters (`U+0000-001F`, `U+007F-009F`)
         *
         * To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role to use for this state machine.
         */
        public var roleArn: kotlin.String? = null
        /**
         * Tags to be added when creating a state machine.
         *
         * An array of key-value pairs. For more information, see [Using Cost Allocation Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html) in the *Amazon Web Services Billing and Cost Management User Guide*, and [Controlling Access Using IAM Tags](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html).
         *
         * Tags may only contain Unicode letters, digits, white space, or these symbols: `_ . : / = + - @`.
         */
        public var tags: List<Tag>? = null
        /**
         * Selects whether X-Ray tracing is enabled.
         */
        public var tracingConfiguration: aws.sdk.kotlin.services.sfn.model.TracingConfiguration? = null
        /**
         * Determines whether a Standard or Express state machine is created. The default is `STANDARD`. You cannot update the `type` of a state machine once it has been created.
         */
        public var type: aws.sdk.kotlin.services.sfn.model.StateMachineType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sfn.model.CreateStateMachineRequest) : this() {
            this.definition = x.definition
            this.loggingConfiguration = x.loggingConfiguration
            this.name = x.name
            this.roleArn = x.roleArn
            this.tags = x.tags
            this.tracingConfiguration = x.tracingConfiguration
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sfn.model.CreateStateMachineRequest = CreateStateMachineRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.LoggingConfiguration] inside the given [block]
         */
        public fun loggingConfiguration(block: aws.sdk.kotlin.services.sfn.model.LoggingConfiguration.Builder.() -> kotlin.Unit) {
            this.loggingConfiguration = aws.sdk.kotlin.services.sfn.model.LoggingConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.TracingConfiguration] inside the given [block]
         */
        public fun tracingConfiguration(block: aws.sdk.kotlin.services.sfn.model.TracingConfiguration.Builder.() -> kotlin.Unit) {
            this.tracingConfiguration = aws.sdk.kotlin.services.sfn.model.TracingConfiguration.invoke(block)
        }
    }
}
