// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sfn.model

import aws.smithy.kotlin.runtime.time.Instant

public class DescribeMapRunResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) that identifies the execution in which the Map Run was started.
     */
    public val executionArn: kotlin.String? = builder.executionArn
    /**
     * A JSON object that contains information about the total number of child workflow executions for the Map Run, and the count of child workflow executions for each status, such as `failed` and `succeeded`.
     */
    public val executionCounts: aws.sdk.kotlin.services.sfn.model.MapRunExecutionCounts? = builder.executionCounts
    /**
     * A JSON object that contains information about the total number of items, and the item count for each processing status, such as `pending` and `failed`.
     */
    public val itemCounts: aws.sdk.kotlin.services.sfn.model.MapRunItemCounts? = builder.itemCounts
    /**
     * The Amazon Resource Name (ARN) that identifies a Map Run.
     */
    public val mapRunArn: kotlin.String? = builder.mapRunArn
    /**
     * The maximum number of child workflow executions configured to run in parallel for the Map Run at the same time.
     */
    public val maxConcurrency: kotlin.Int = builder.maxConcurrency
    /**
     * The date when the Map Run was started.
     */
    public val startDate: aws.smithy.kotlin.runtime.time.Instant? = builder.startDate
    /**
     * The current status of the Map Run.
     */
    public val status: aws.sdk.kotlin.services.sfn.model.MapRunStatus? = builder.status
    /**
     * The date when the Map Run was stopped.
     */
    public val stopDate: aws.smithy.kotlin.runtime.time.Instant? = builder.stopDate
    /**
     * The maximum number of failed child workflow executions before the Map Run fails.
     */
    public val toleratedFailureCount: kotlin.Long = builder.toleratedFailureCount
    /**
     * The maximum percentage of failed child workflow executions before the Map Run fails.
     */
    public val toleratedFailurePercentage: kotlin.Float = builder.toleratedFailurePercentage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sfn.model.DescribeMapRunResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeMapRunResponse(")
        append("executionArn=$executionArn,")
        append("executionCounts=$executionCounts,")
        append("itemCounts=$itemCounts,")
        append("mapRunArn=$mapRunArn,")
        append("maxConcurrency=$maxConcurrency,")
        append("startDate=$startDate,")
        append("status=$status,")
        append("stopDate=$stopDate,")
        append("toleratedFailureCount=$toleratedFailureCount,")
        append("toleratedFailurePercentage=$toleratedFailurePercentage")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = executionArn?.hashCode() ?: 0
        result = 31 * result + (executionCounts?.hashCode() ?: 0)
        result = 31 * result + (itemCounts?.hashCode() ?: 0)
        result = 31 * result + (mapRunArn?.hashCode() ?: 0)
        result = 31 * result + (maxConcurrency)
        result = 31 * result + (startDate?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (stopDate?.hashCode() ?: 0)
        result = 31 * result + (toleratedFailureCount.hashCode())
        result = 31 * result + (toleratedFailurePercentage.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeMapRunResponse

        if (executionArn != other.executionArn) return false
        if (executionCounts != other.executionCounts) return false
        if (itemCounts != other.itemCounts) return false
        if (mapRunArn != other.mapRunArn) return false
        if (maxConcurrency != other.maxConcurrency) return false
        if (startDate != other.startDate) return false
        if (status != other.status) return false
        if (stopDate != other.stopDate) return false
        if (toleratedFailureCount != other.toleratedFailureCount) return false
        if (toleratedFailurePercentage != other.toleratedFailurePercentage) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sfn.model.DescribeMapRunResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) that identifies the execution in which the Map Run was started.
         */
        public var executionArn: kotlin.String? = null
        /**
         * A JSON object that contains information about the total number of child workflow executions for the Map Run, and the count of child workflow executions for each status, such as `failed` and `succeeded`.
         */
        public var executionCounts: aws.sdk.kotlin.services.sfn.model.MapRunExecutionCounts? = null
        /**
         * A JSON object that contains information about the total number of items, and the item count for each processing status, such as `pending` and `failed`.
         */
        public var itemCounts: aws.sdk.kotlin.services.sfn.model.MapRunItemCounts? = null
        /**
         * The Amazon Resource Name (ARN) that identifies a Map Run.
         */
        public var mapRunArn: kotlin.String? = null
        /**
         * The maximum number of child workflow executions configured to run in parallel for the Map Run at the same time.
         */
        public var maxConcurrency: kotlin.Int = 0
        /**
         * The date when the Map Run was started.
         */
        public var startDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The current status of the Map Run.
         */
        public var status: aws.sdk.kotlin.services.sfn.model.MapRunStatus? = null
        /**
         * The date when the Map Run was stopped.
         */
        public var stopDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The maximum number of failed child workflow executions before the Map Run fails.
         */
        public var toleratedFailureCount: kotlin.Long = 0L
        /**
         * The maximum percentage of failed child workflow executions before the Map Run fails.
         */
        public var toleratedFailurePercentage: kotlin.Float = 0.0f

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sfn.model.DescribeMapRunResponse) : this() {
            this.executionArn = x.executionArn
            this.executionCounts = x.executionCounts
            this.itemCounts = x.itemCounts
            this.mapRunArn = x.mapRunArn
            this.maxConcurrency = x.maxConcurrency
            this.startDate = x.startDate
            this.status = x.status
            this.stopDate = x.stopDate
            this.toleratedFailureCount = x.toleratedFailureCount
            this.toleratedFailurePercentage = x.toleratedFailurePercentage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sfn.model.DescribeMapRunResponse = DescribeMapRunResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.MapRunExecutionCounts] inside the given [block]
         */
        public fun executionCounts(block: aws.sdk.kotlin.services.sfn.model.MapRunExecutionCounts.Builder.() -> kotlin.Unit) {
            this.executionCounts = aws.sdk.kotlin.services.sfn.model.MapRunExecutionCounts.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.MapRunItemCounts] inside the given [block]
         */
        public fun itemCounts(block: aws.sdk.kotlin.services.sfn.model.MapRunItemCounts.Builder.() -> kotlin.Unit) {
            this.itemCounts = aws.sdk.kotlin.services.sfn.model.MapRunItemCounts.invoke(block)
        }
    }
}
