// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sfn.model

import aws.smithy.kotlin.runtime.time.Instant

public class DescribeStateMachineResponse private constructor(builder: Builder) {
    /**
     * The date the state machine is created.
     */
    public val creationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDate
    /**
     * The Amazon States Language definition of the state machine. See [Amazon States Language](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html).
     */
    public val definition: kotlin.String? = builder.definition
    /**
     * A user-defined or an auto-generated string that identifies a `Map` state. This parameter is present only if the `stateMachineArn` specified in input is a qualified state machine ARN.
     */
    public val label: kotlin.String? = builder.label
    /**
     * The `LoggingConfiguration` data type is used to set CloudWatch Logs options.
     */
    public val loggingConfiguration: aws.sdk.kotlin.services.sfn.model.LoggingConfiguration? = builder.loggingConfiguration
    /**
     * The name of the state machine.
     *
     * A name must *not* contain:
     * + white space
     * + brackets `< > { } [ ]`
     * + wildcard characters `? *`
     * + special characters `" # % \ ^ | ~ ` $ & , ; : /`
     * + control characters (`U+0000-001F`, `U+007F-009F`)
     *
     * To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Amazon Resource Name (ARN) of the IAM role used when creating this state machine. (The IAM role maintains security by granting Step Functions access to Amazon Web Services resources.)
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The Amazon Resource Name (ARN) that identifies the state machine.
     */
    public val stateMachineArn: kotlin.String? = builder.stateMachineArn
    /**
     * The current status of the state machine.
     */
    public val status: aws.sdk.kotlin.services.sfn.model.StateMachineStatus? = builder.status
    /**
     * Selects whether X-Ray tracing is enabled.
     */
    public val tracingConfiguration: aws.sdk.kotlin.services.sfn.model.TracingConfiguration? = builder.tracingConfiguration
    /**
     * The `type` of the state machine (`STANDARD` or `EXPRESS`).
     */
    public val type: aws.sdk.kotlin.services.sfn.model.StateMachineType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sfn.model.DescribeStateMachineResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeStateMachineResponse(")
        append("creationDate=$creationDate,")
        append("definition=*** Sensitive Data Redacted ***,")
        append("label=$label,")
        append("loggingConfiguration=$loggingConfiguration,")
        append("name=$name,")
        append("roleArn=$roleArn,")
        append("stateMachineArn=$stateMachineArn,")
        append("status=$status,")
        append("tracingConfiguration=$tracingConfiguration,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationDate?.hashCode() ?: 0
        result = 31 * result + (definition?.hashCode() ?: 0)
        result = 31 * result + (label?.hashCode() ?: 0)
        result = 31 * result + (loggingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (stateMachineArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tracingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeStateMachineResponse

        if (creationDate != other.creationDate) return false
        if (definition != other.definition) return false
        if (label != other.label) return false
        if (loggingConfiguration != other.loggingConfiguration) return false
        if (name != other.name) return false
        if (roleArn != other.roleArn) return false
        if (stateMachineArn != other.stateMachineArn) return false
        if (status != other.status) return false
        if (tracingConfiguration != other.tracingConfiguration) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sfn.model.DescribeStateMachineResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The date the state machine is created.
         */
        public var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon States Language definition of the state machine. See [Amazon States Language](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html).
         */
        public var definition: kotlin.String? = null
        /**
         * A user-defined or an auto-generated string that identifies a `Map` state. This parameter is present only if the `stateMachineArn` specified in input is a qualified state machine ARN.
         */
        public var label: kotlin.String? = null
        /**
         * The `LoggingConfiguration` data type is used to set CloudWatch Logs options.
         */
        public var loggingConfiguration: aws.sdk.kotlin.services.sfn.model.LoggingConfiguration? = null
        /**
         * The name of the state machine.
         *
         * A name must *not* contain:
         * + white space
         * + brackets `< > { } [ ]`
         * + wildcard characters `? *`
         * + special characters `" # % \ ^ | ~ ` $ & , ; : /`
         * + control characters (`U+0000-001F`, `U+007F-009F`)
         *
         * To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role used when creating this state machine. (The IAM role maintains security by granting Step Functions access to Amazon Web Services resources.)
         */
        public var roleArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) that identifies the state machine.
         */
        public var stateMachineArn: kotlin.String? = null
        /**
         * The current status of the state machine.
         */
        public var status: aws.sdk.kotlin.services.sfn.model.StateMachineStatus? = null
        /**
         * Selects whether X-Ray tracing is enabled.
         */
        public var tracingConfiguration: aws.sdk.kotlin.services.sfn.model.TracingConfiguration? = null
        /**
         * The `type` of the state machine (`STANDARD` or `EXPRESS`).
         */
        public var type: aws.sdk.kotlin.services.sfn.model.StateMachineType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sfn.model.DescribeStateMachineResponse) : this() {
            this.creationDate = x.creationDate
            this.definition = x.definition
            this.label = x.label
            this.loggingConfiguration = x.loggingConfiguration
            this.name = x.name
            this.roleArn = x.roleArn
            this.stateMachineArn = x.stateMachineArn
            this.status = x.status
            this.tracingConfiguration = x.tracingConfiguration
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sfn.model.DescribeStateMachineResponse = DescribeStateMachineResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.LoggingConfiguration] inside the given [block]
         */
        public fun loggingConfiguration(block: aws.sdk.kotlin.services.sfn.model.LoggingConfiguration.Builder.() -> kotlin.Unit) {
            this.loggingConfiguration = aws.sdk.kotlin.services.sfn.model.LoggingConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.TracingConfiguration] inside the given [block]
         */
        public fun tracingConfiguration(block: aws.sdk.kotlin.services.sfn.model.TracingConfiguration.Builder.() -> kotlin.Unit) {
            this.tracingConfiguration = aws.sdk.kotlin.services.sfn.model.TracingConfiguration.invoke(block)
        }
    }
}
