// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sfn.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains details about an execution.
 */
public class ExecutionListItem private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) that identifies the execution.
     */
    public val executionArn: kotlin.String? = builder.executionArn
    /**
     * The total number of items processed in a child workflow execution. This field is returned only if `mapRunArn` was specified in the `ListExecutions` API action. If `stateMachineArn` was specified in `ListExecutions`, the `itemCount` field isn't returned.
     */
    public val itemCount: kotlin.Int? = builder.itemCount
    /**
     * The Amazon Resource Name (ARN) of a Map Run. This field is returned only if `mapRunArn` was specified in the `ListExecutions` API action. If `stateMachineArn` was specified in `ListExecutions`, the `mapRunArn` isn't returned.
     */
    public val mapRunArn: kotlin.String? = builder.mapRunArn
    /**
     * The name of the execution.
     *
     * A name must *not* contain:
     * + white space
     * + brackets `< > { } [ ]`
     * + wildcard characters `? *`
     * + special characters `" # % \ ^ | ~ ` $ & , ; : /`
     * + control characters (`U+0000-001F`, `U+007F-009F`)
     *
     * To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The date the execution started.
     */
    public val startDate: aws.smithy.kotlin.runtime.time.Instant? = builder.startDate
    /**
     * The Amazon Resource Name (ARN) of the executed state machine.
     */
    public val stateMachineArn: kotlin.String? = builder.stateMachineArn
    /**
     * The current status of the execution.
     */
    public val status: aws.sdk.kotlin.services.sfn.model.ExecutionStatus? = builder.status
    /**
     * If the execution already ended, the date the execution stopped.
     */
    public val stopDate: aws.smithy.kotlin.runtime.time.Instant? = builder.stopDate

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sfn.model.ExecutionListItem = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ExecutionListItem(")
        append("executionArn=$executionArn,")
        append("itemCount=$itemCount,")
        append("mapRunArn=$mapRunArn,")
        append("name=$name,")
        append("startDate=$startDate,")
        append("stateMachineArn=$stateMachineArn,")
        append("status=$status,")
        append("stopDate=$stopDate")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = executionArn?.hashCode() ?: 0
        result = 31 * result + (itemCount ?: 0)
        result = 31 * result + (mapRunArn?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (startDate?.hashCode() ?: 0)
        result = 31 * result + (stateMachineArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (stopDate?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ExecutionListItem

        if (executionArn != other.executionArn) return false
        if (itemCount != other.itemCount) return false
        if (mapRunArn != other.mapRunArn) return false
        if (name != other.name) return false
        if (startDate != other.startDate) return false
        if (stateMachineArn != other.stateMachineArn) return false
        if (status != other.status) return false
        if (stopDate != other.stopDate) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sfn.model.ExecutionListItem = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) that identifies the execution.
         */
        public var executionArn: kotlin.String? = null
        /**
         * The total number of items processed in a child workflow execution. This field is returned only if `mapRunArn` was specified in the `ListExecutions` API action. If `stateMachineArn` was specified in `ListExecutions`, the `itemCount` field isn't returned.
         */
        public var itemCount: kotlin.Int? = null
        /**
         * The Amazon Resource Name (ARN) of a Map Run. This field is returned only if `mapRunArn` was specified in the `ListExecutions` API action. If `stateMachineArn` was specified in `ListExecutions`, the `mapRunArn` isn't returned.
         */
        public var mapRunArn: kotlin.String? = null
        /**
         * The name of the execution.
         *
         * A name must *not* contain:
         * + white space
         * + brackets `< > { } [ ]`
         * + wildcard characters `? *`
         * + special characters `" # % \ ^ | ~ ` $ & , ; : /`
         * + control characters (`U+0000-001F`, `U+007F-009F`)
         *
         * To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.
         */
        public var name: kotlin.String? = null
        /**
         * The date the execution started.
         */
        public var startDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the executed state machine.
         */
        public var stateMachineArn: kotlin.String? = null
        /**
         * The current status of the execution.
         */
        public var status: aws.sdk.kotlin.services.sfn.model.ExecutionStatus? = null
        /**
         * If the execution already ended, the date the execution stopped.
         */
        public var stopDate: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sfn.model.ExecutionListItem) : this() {
            this.executionArn = x.executionArn
            this.itemCount = x.itemCount
            this.mapRunArn = x.mapRunArn
            this.name = x.name
            this.startDate = x.startDate
            this.stateMachineArn = x.stateMachineArn
            this.status = x.status
            this.stopDate = x.stopDate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sfn.model.ExecutionListItem = ExecutionListItem(this)
    }
}
