// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sfn.model



public class GetExecutionHistoryRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the execution.
     */
    public val executionArn: kotlin.String? = builder.executionArn
    /**
     * You can select whether execution data (input or output of a history event) is returned. The default is `true`.
     */
    public val includeExecutionData: kotlin.Boolean? = builder.includeExecutionData
    /**
     * The maximum number of results that are returned per call. You can use `nextToken` to obtain further pages of results. The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the default.
     *
     * This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum.
     */
    public val maxResults: kotlin.Int = builder.maxResults
    /**
     * If `nextToken` is returned, there are more results available. The value of `nextToken` is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an *HTTP 400 InvalidToken* error.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * Lists events in descending order of their `timeStamp`.
     */
    public val reverseOrder: kotlin.Boolean = builder.reverseOrder

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sfn.model.GetExecutionHistoryRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetExecutionHistoryRequest(")
        append("executionArn=$executionArn,")
        append("includeExecutionData=$includeExecutionData,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("reverseOrder=$reverseOrder")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = executionArn?.hashCode() ?: 0
        result = 31 * result + (includeExecutionData?.hashCode() ?: 0)
        result = 31 * result + (maxResults)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (reverseOrder.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetExecutionHistoryRequest

        if (executionArn != other.executionArn) return false
        if (includeExecutionData != other.includeExecutionData) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (reverseOrder != other.reverseOrder) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sfn.model.GetExecutionHistoryRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the execution.
         */
        public var executionArn: kotlin.String? = null
        /**
         * You can select whether execution data (input or output of a history event) is returned. The default is `true`.
         */
        public var includeExecutionData: kotlin.Boolean? = null
        /**
         * The maximum number of results that are returned per call. You can use `nextToken` to obtain further pages of results. The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the default.
         *
         * This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum.
         */
        public var maxResults: kotlin.Int = 0
        /**
         * If `nextToken` is returned, there are more results available. The value of `nextToken` is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an *HTTP 400 InvalidToken* error.
         */
        public var nextToken: kotlin.String? = null
        /**
         * Lists events in descending order of their `timeStamp`.
         */
        public var reverseOrder: kotlin.Boolean = false

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sfn.model.GetExecutionHistoryRequest) : this() {
            this.executionArn = x.executionArn
            this.includeExecutionData = x.includeExecutionData
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.reverseOrder = x.reverseOrder
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sfn.model.GetExecutionHistoryRequest = GetExecutionHistoryRequest(this)
    }
}
