// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sfn.model



/**
 * Contains details about a Lambda function scheduled during an execution.
 */
public class LambdaFunctionScheduledEventDetails private constructor(builder: Builder) {
    /**
     * The JSON data input to the Lambda function. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.
     */
    public val input: kotlin.String? = builder.input
    /**
     * Contains details about input for an execution history event.
     */
    public val inputDetails: aws.sdk.kotlin.services.sfn.model.HistoryEventExecutionDataDetails? = builder.inputDetails
    /**
     * The Amazon Resource Name (ARN) of the scheduled Lambda function.
     */
    public val resource: kotlin.String? = builder.resource
    /**
     * The credentials that Step Functions uses for the task.
     */
    public val taskCredentials: aws.sdk.kotlin.services.sfn.model.TaskCredentials? = builder.taskCredentials
    /**
     * The maximum allowed duration of the Lambda function.
     */
    public val timeoutInSeconds: kotlin.Long? = builder.timeoutInSeconds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sfn.model.LambdaFunctionScheduledEventDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LambdaFunctionScheduledEventDetails(")
        append("input=*** Sensitive Data Redacted ***,")
        append("inputDetails=$inputDetails,")
        append("resource=$resource,")
        append("taskCredentials=$taskCredentials,")
        append("timeoutInSeconds=$timeoutInSeconds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = input?.hashCode() ?: 0
        result = 31 * result + (inputDetails?.hashCode() ?: 0)
        result = 31 * result + (resource?.hashCode() ?: 0)
        result = 31 * result + (taskCredentials?.hashCode() ?: 0)
        result = 31 * result + (timeoutInSeconds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LambdaFunctionScheduledEventDetails

        if (input != other.input) return false
        if (inputDetails != other.inputDetails) return false
        if (resource != other.resource) return false
        if (taskCredentials != other.taskCredentials) return false
        if (timeoutInSeconds != other.timeoutInSeconds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sfn.model.LambdaFunctionScheduledEventDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The JSON data input to the Lambda function. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.
         */
        public var input: kotlin.String? = null
        /**
         * Contains details about input for an execution history event.
         */
        public var inputDetails: aws.sdk.kotlin.services.sfn.model.HistoryEventExecutionDataDetails? = null
        /**
         * The Amazon Resource Name (ARN) of the scheduled Lambda function.
         */
        public var resource: kotlin.String? = null
        /**
         * The credentials that Step Functions uses for the task.
         */
        public var taskCredentials: aws.sdk.kotlin.services.sfn.model.TaskCredentials? = null
        /**
         * The maximum allowed duration of the Lambda function.
         */
        public var timeoutInSeconds: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sfn.model.LambdaFunctionScheduledEventDetails) : this() {
            this.input = x.input
            this.inputDetails = x.inputDetails
            this.resource = x.resource
            this.taskCredentials = x.taskCredentials
            this.timeoutInSeconds = x.timeoutInSeconds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sfn.model.LambdaFunctionScheduledEventDetails = LambdaFunctionScheduledEventDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.HistoryEventExecutionDataDetails] inside the given [block]
         */
        public fun inputDetails(block: aws.sdk.kotlin.services.sfn.model.HistoryEventExecutionDataDetails.Builder.() -> kotlin.Unit) {
            this.inputDetails = aws.sdk.kotlin.services.sfn.model.HistoryEventExecutionDataDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sfn.model.TaskCredentials] inside the given [block]
         */
        public fun taskCredentials(block: aws.sdk.kotlin.services.sfn.model.TaskCredentials.Builder.() -> kotlin.Unit) {
            this.taskCredentials = aws.sdk.kotlin.services.sfn.model.TaskCredentials.invoke(block)
        }
    }
}
