// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sfn.model



/**
 * Contains details about items that were processed in all of the child workflow executions that were started by a Map Run.
 */
public class MapRunItemCounts private constructor(builder: Builder) {
    /**
     * The total number of items processed in child workflow executions that were either stopped by the user or by Step Functions, because the Map Run failed.
     */
    public val aborted: kotlin.Long = builder.aborted
    /**
     * The total number of items processed in child workflow executions that have failed.
     */
    public val failed: kotlin.Long = builder.failed
    /**
     * The total number of items to process in child workflow executions that haven't started running yet.
     */
    public val pending: kotlin.Long = builder.pending
    /**
     * Returns the count of items whose results were written by `ResultWriter`. For more information, see [ResultWriter](https://docs.aws.amazon.com/step-functions/latest/dg/input-output-resultwriter.html) in the *Step Functions Developer Guide*.
     */
    public val resultsWritten: kotlin.Long = builder.resultsWritten
    /**
     * The total number of items being processed in child workflow executions that are currently in-progress.
     */
    public val running: kotlin.Long = builder.running
    /**
     * The total number of items processed in child workflow executions that have completed successfully.
     */
    public val succeeded: kotlin.Long = builder.succeeded
    /**
     * The total number of items processed in child workflow executions that have timed out.
     */
    public val timedOut: kotlin.Long = builder.timedOut
    /**
     * The total number of items processed in all the child workflow executions started by a Map Run.
     */
    public val total: kotlin.Long = builder.total

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sfn.model.MapRunItemCounts = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MapRunItemCounts(")
        append("aborted=$aborted,")
        append("failed=$failed,")
        append("pending=$pending,")
        append("resultsWritten=$resultsWritten,")
        append("running=$running,")
        append("succeeded=$succeeded,")
        append("timedOut=$timedOut,")
        append("total=$total")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = aborted.hashCode()
        result = 31 * result + (failed.hashCode())
        result = 31 * result + (pending.hashCode())
        result = 31 * result + (resultsWritten.hashCode())
        result = 31 * result + (running.hashCode())
        result = 31 * result + (succeeded.hashCode())
        result = 31 * result + (timedOut.hashCode())
        result = 31 * result + (total.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MapRunItemCounts

        if (aborted != other.aborted) return false
        if (failed != other.failed) return false
        if (pending != other.pending) return false
        if (resultsWritten != other.resultsWritten) return false
        if (running != other.running) return false
        if (succeeded != other.succeeded) return false
        if (timedOut != other.timedOut) return false
        if (total != other.total) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sfn.model.MapRunItemCounts = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The total number of items processed in child workflow executions that were either stopped by the user or by Step Functions, because the Map Run failed.
         */
        public var aborted: kotlin.Long = 0L
        /**
         * The total number of items processed in child workflow executions that have failed.
         */
        public var failed: kotlin.Long = 0L
        /**
         * The total number of items to process in child workflow executions that haven't started running yet.
         */
        public var pending: kotlin.Long = 0L
        /**
         * Returns the count of items whose results were written by `ResultWriter`. For more information, see [ResultWriter](https://docs.aws.amazon.com/step-functions/latest/dg/input-output-resultwriter.html) in the *Step Functions Developer Guide*.
         */
        public var resultsWritten: kotlin.Long = 0L
        /**
         * The total number of items being processed in child workflow executions that are currently in-progress.
         */
        public var running: kotlin.Long = 0L
        /**
         * The total number of items processed in child workflow executions that have completed successfully.
         */
        public var succeeded: kotlin.Long = 0L
        /**
         * The total number of items processed in child workflow executions that have timed out.
         */
        public var timedOut: kotlin.Long = 0L
        /**
         * The total number of items processed in all the child workflow executions started by a Map Run.
         */
        public var total: kotlin.Long = 0L

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sfn.model.MapRunItemCounts) : this() {
            this.aborted = x.aborted
            this.failed = x.failed
            this.pending = x.pending
            this.resultsWritten = x.resultsWritten
            this.running = x.running
            this.succeeded = x.succeeded
            this.timedOut = x.timedOut
            this.total = x.total
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sfn.model.MapRunItemCounts = MapRunItemCounts(this)
    }
}
