// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sfn.paginators

import aws.sdk.kotlin.services.sfn.SfnClient
import aws.sdk.kotlin.services.sfn.model.ActivityListItem
import aws.sdk.kotlin.services.sfn.model.ExecutionListItem
import aws.sdk.kotlin.services.sfn.model.GetExecutionHistoryRequest
import aws.sdk.kotlin.services.sfn.model.GetExecutionHistoryResponse
import aws.sdk.kotlin.services.sfn.model.HistoryEvent
import aws.sdk.kotlin.services.sfn.model.ListActivitiesRequest
import aws.sdk.kotlin.services.sfn.model.ListActivitiesResponse
import aws.sdk.kotlin.services.sfn.model.ListExecutionsRequest
import aws.sdk.kotlin.services.sfn.model.ListExecutionsResponse
import aws.sdk.kotlin.services.sfn.model.ListMapRunsRequest
import aws.sdk.kotlin.services.sfn.model.ListMapRunsResponse
import aws.sdk.kotlin.services.sfn.model.ListStateMachinesRequest
import aws.sdk.kotlin.services.sfn.model.ListStateMachinesResponse
import aws.sdk.kotlin.services.sfn.model.MapRunListItem
import aws.sdk.kotlin.services.sfn.model.StateMachineListItem
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [GetExecutionHistoryResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetExecutionHistoryRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetExecutionHistoryResponse]
 */
public fun SfnClient.getExecutionHistoryPaginated(initialRequest: GetExecutionHistoryRequest): Flow<GetExecutionHistoryResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getExecutionHistoryPaginated.getExecutionHistory(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [GetExecutionHistoryResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetExecutionHistoryResponse]
 */
public fun SfnClient.getExecutionHistoryPaginated(block: GetExecutionHistoryRequest.Builder.() -> Unit): Flow<GetExecutionHistoryResponse> =
    getExecutionHistoryPaginated(GetExecutionHistoryRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getExecutionHistoryPaginated]
 * to access the nested member [HistoryEvent]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [HistoryEvent]
 */
@JvmName("getExecutionHistoryResponseHistoryEvent")
public fun Flow<GetExecutionHistoryResponse>.events(): Flow<HistoryEvent> =
    transform() { response ->
        response.events?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListActivitiesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListActivitiesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListActivitiesResponse]
 */
public fun SfnClient.listActivitiesPaginated(initialRequest: ListActivitiesRequest): Flow<ListActivitiesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listActivitiesPaginated.listActivities(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListActivitiesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListActivitiesResponse]
 */
public fun SfnClient.listActivitiesPaginated(block: ListActivitiesRequest.Builder.() -> Unit): Flow<ListActivitiesResponse> =
    listActivitiesPaginated(ListActivitiesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listActivitiesPaginated]
 * to access the nested member [ActivityListItem]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ActivityListItem]
 */
@JvmName("listActivitiesResponseActivityListItem")
public fun Flow<ListActivitiesResponse>.activities(): Flow<ActivityListItem> =
    transform() { response ->
        response.activities?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListExecutionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListExecutionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListExecutionsResponse]
 */
public fun SfnClient.listExecutionsPaginated(initialRequest: ListExecutionsRequest): Flow<ListExecutionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listExecutionsPaginated.listExecutions(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListExecutionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListExecutionsResponse]
 */
public fun SfnClient.listExecutionsPaginated(block: ListExecutionsRequest.Builder.() -> Unit): Flow<ListExecutionsResponse> =
    listExecutionsPaginated(ListExecutionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listExecutionsPaginated]
 * to access the nested member [ExecutionListItem]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ExecutionListItem]
 */
@JvmName("listExecutionsResponseExecutionListItem")
public fun Flow<ListExecutionsResponse>.executions(): Flow<ExecutionListItem> =
    transform() { response ->
        response.executions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListMapRunsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListMapRunsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMapRunsResponse]
 */
public fun SfnClient.listMapRunsPaginated(initialRequest: ListMapRunsRequest): Flow<ListMapRunsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listMapRunsPaginated.listMapRuns(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListMapRunsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMapRunsResponse]
 */
public fun SfnClient.listMapRunsPaginated(block: ListMapRunsRequest.Builder.() -> Unit): Flow<ListMapRunsResponse> =
    listMapRunsPaginated(ListMapRunsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listMapRunsPaginated]
 * to access the nested member [MapRunListItem]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [MapRunListItem]
 */
@JvmName("listMapRunsResponseMapRunListItem")
public fun Flow<ListMapRunsResponse>.mapRuns(): Flow<MapRunListItem> =
    transform() { response ->
        response.mapRuns?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListStateMachinesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListStateMachinesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStateMachinesResponse]
 */
public fun SfnClient.listStateMachinesPaginated(initialRequest: ListStateMachinesRequest): Flow<ListStateMachinesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listStateMachinesPaginated.listStateMachines(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListStateMachinesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStateMachinesResponse]
 */
public fun SfnClient.listStateMachinesPaginated(block: ListStateMachinesRequest.Builder.() -> Unit): Flow<ListStateMachinesResponse> =
    listStateMachinesPaginated(ListStateMachinesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listStateMachinesPaginated]
 * to access the nested member [StateMachineListItem]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [StateMachineListItem]
 */
@JvmName("listStateMachinesResponseStateMachineListItem")
public fun Flow<ListStateMachinesResponse>.stateMachines(): Flow<StateMachineListItem> =
    transform() { response ->
        response.stateMachines?.forEach {
            emit(it)
        }
    }
