// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sfn.transform

import aws.sdk.kotlin.services.sfn.model.CreateActivityResponse
import aws.sdk.kotlin.services.sfn.model.SfnException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class CreateActivityOperationDeserializer: HttpDeserialize<CreateActivityResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateActivityResponse {
        if (!response.status.isSuccess()) {
            throwCreateActivityError(context, response)
        }
        val builder = CreateActivityResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateActivityOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateActivityError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SfnException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ActivityLimitExceeded" -> ActivityLimitExceededDeserializer().deserialize(context, wrappedResponse)
        "InvalidName" -> InvalidNameDeserializer().deserialize(context, wrappedResponse)
        "TooManyTags" -> TooManyTagsDeserializer().deserialize(context, wrappedResponse)
        else -> SfnException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateActivityOperationBody(builder: CreateActivityResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACTIVITYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("activityArn"))
    val CREATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationDate"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACTIVITYARN_DESCRIPTOR)
        field(CREATIONDATE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACTIVITYARN_DESCRIPTOR.index -> builder.activityArn = deserializeString()
                CREATIONDATE_DESCRIPTOR.index -> builder.creationDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
