// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sfn.transform

import aws.sdk.kotlin.services.sfn.model.CloudWatchEventsExecutionDataDetails
import aws.sdk.kotlin.services.sfn.model.DescribeExecutionResponse
import aws.sdk.kotlin.services.sfn.model.ExecutionStatus
import aws.sdk.kotlin.services.sfn.model.SfnException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeExecutionOperationDeserializer: HttpDeserialize<DescribeExecutionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeExecutionResponse {
        if (!response.status.isSuccess()) {
            throwDescribeExecutionError(context, response)
        }
        val builder = DescribeExecutionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeExecutionOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeExecutionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SfnException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ExecutionDoesNotExist" -> ExecutionDoesNotExistDeserializer().deserialize(context, wrappedResponse)
        "InvalidArn" -> InvalidArnDeserializer().deserialize(context, wrappedResponse)
        else -> SfnException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeExecutionOperationBody(builder: DescribeExecutionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CAUSE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("cause"))
    val ERROR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("error"))
    val EXECUTIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("executionArn"))
    val INPUT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("input"))
    val INPUTDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("inputDetails"))
    val MAPRUNARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("mapRunArn"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val OUTPUT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("output"))
    val OUTPUTDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("outputDetails"))
    val STARTDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("startDate"))
    val STATEMACHINEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("stateMachineArn"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val STOPDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("stopDate"))
    val TRACEHEADER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("traceHeader"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CAUSE_DESCRIPTOR)
        field(ERROR_DESCRIPTOR)
        field(EXECUTIONARN_DESCRIPTOR)
        field(INPUT_DESCRIPTOR)
        field(INPUTDETAILS_DESCRIPTOR)
        field(MAPRUNARN_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(OUTPUT_DESCRIPTOR)
        field(OUTPUTDETAILS_DESCRIPTOR)
        field(STARTDATE_DESCRIPTOR)
        field(STATEMACHINEARN_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(STOPDATE_DESCRIPTOR)
        field(TRACEHEADER_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CAUSE_DESCRIPTOR.index -> builder.cause = deserializeString()
                ERROR_DESCRIPTOR.index -> builder.error = deserializeString()
                EXECUTIONARN_DESCRIPTOR.index -> builder.executionArn = deserializeString()
                INPUT_DESCRIPTOR.index -> builder.input = deserializeString()
                INPUTDETAILS_DESCRIPTOR.index -> builder.inputDetails = deserializeCloudWatchEventsExecutionDataDetailsDocument(deserializer)
                MAPRUNARN_DESCRIPTOR.index -> builder.mapRunArn = deserializeString()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                OUTPUT_DESCRIPTOR.index -> builder.output = deserializeString()
                OUTPUTDETAILS_DESCRIPTOR.index -> builder.outputDetails = deserializeCloudWatchEventsExecutionDataDetailsDocument(deserializer)
                STARTDATE_DESCRIPTOR.index -> builder.startDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                STATEMACHINEARN_DESCRIPTOR.index -> builder.stateMachineArn = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { ExecutionStatus.fromValue(it) }
                STOPDATE_DESCRIPTOR.index -> builder.stopDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                TRACEHEADER_DESCRIPTOR.index -> builder.traceHeader = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
