// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sfn.transform

import aws.sdk.kotlin.services.sfn.model.DescribeMapRunResponse
import aws.sdk.kotlin.services.sfn.model.MapRunExecutionCounts
import aws.sdk.kotlin.services.sfn.model.MapRunItemCounts
import aws.sdk.kotlin.services.sfn.model.MapRunStatus
import aws.sdk.kotlin.services.sfn.model.SfnException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeMapRunOperationDeserializer: HttpDeserialize<DescribeMapRunResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeMapRunResponse {
        if (!response.status.isSuccess()) {
            throwDescribeMapRunError(context, response)
        }
        val builder = DescribeMapRunResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeMapRunOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeMapRunError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SfnException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidArn" -> InvalidArnDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFound" -> ResourceNotFoundDeserializer().deserialize(context, wrappedResponse)
        else -> SfnException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeMapRunOperationBody(builder: DescribeMapRunResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val EXECUTIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("executionArn"))
    val EXECUTIONCOUNTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("executionCounts"))
    val ITEMCOUNTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("itemCounts"))
    val MAPRUNARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("mapRunArn"))
    val MAXCONCURRENCY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("maxConcurrency"))
    val STARTDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("startDate"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val STOPDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("stopDate"))
    val TOLERATEDFAILURECOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("toleratedFailureCount"))
    val TOLERATEDFAILUREPERCENTAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Float, JsonSerialName("toleratedFailurePercentage"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(EXECUTIONARN_DESCRIPTOR)
        field(EXECUTIONCOUNTS_DESCRIPTOR)
        field(ITEMCOUNTS_DESCRIPTOR)
        field(MAPRUNARN_DESCRIPTOR)
        field(MAXCONCURRENCY_DESCRIPTOR)
        field(STARTDATE_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(STOPDATE_DESCRIPTOR)
        field(TOLERATEDFAILURECOUNT_DESCRIPTOR)
        field(TOLERATEDFAILUREPERCENTAGE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                EXECUTIONARN_DESCRIPTOR.index -> builder.executionArn = deserializeString()
                EXECUTIONCOUNTS_DESCRIPTOR.index -> builder.executionCounts = deserializeMapRunExecutionCountsDocument(deserializer)
                ITEMCOUNTS_DESCRIPTOR.index -> builder.itemCounts = deserializeMapRunItemCountsDocument(deserializer)
                MAPRUNARN_DESCRIPTOR.index -> builder.mapRunArn = deserializeString()
                MAXCONCURRENCY_DESCRIPTOR.index -> builder.maxConcurrency = deserializeInt()
                STARTDATE_DESCRIPTOR.index -> builder.startDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { MapRunStatus.fromValue(it) }
                STOPDATE_DESCRIPTOR.index -> builder.stopDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                TOLERATEDFAILURECOUNT_DESCRIPTOR.index -> builder.toleratedFailureCount = deserializeLong()
                TOLERATEDFAILUREPERCENTAGE_DESCRIPTOR.index -> builder.toleratedFailurePercentage = deserializeFloat()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
