// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sfn.transform

import aws.sdk.kotlin.services.sfn.model.DescribeStateMachineResponse
import aws.sdk.kotlin.services.sfn.model.LoggingConfiguration
import aws.sdk.kotlin.services.sfn.model.SfnException
import aws.sdk.kotlin.services.sfn.model.StateMachineStatus
import aws.sdk.kotlin.services.sfn.model.StateMachineType
import aws.sdk.kotlin.services.sfn.model.TracingConfiguration
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeStateMachineOperationDeserializer: HttpDeserialize<DescribeStateMachineResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeStateMachineResponse {
        if (!response.status.isSuccess()) {
            throwDescribeStateMachineError(context, response)
        }
        val builder = DescribeStateMachineResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeStateMachineOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeStateMachineError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SfnException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidArn" -> InvalidArnDeserializer().deserialize(context, wrappedResponse)
        "StateMachineDoesNotExist" -> StateMachineDoesNotExistDeserializer().deserialize(context, wrappedResponse)
        else -> SfnException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeStateMachineOperationBody(builder: DescribeStateMachineResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationDate"))
    val DEFINITION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("definition"))
    val LABEL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("label"))
    val LOGGINGCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("loggingConfiguration"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("roleArn"))
    val STATEMACHINEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("stateMachineArn"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val TRACINGCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("tracingConfiguration"))
    val TYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("type"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONDATE_DESCRIPTOR)
        field(DEFINITION_DESCRIPTOR)
        field(LABEL_DESCRIPTOR)
        field(LOGGINGCONFIGURATION_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(STATEMACHINEARN_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TRACINGCONFIGURATION_DESCRIPTOR)
        field(TYPE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONDATE_DESCRIPTOR.index -> builder.creationDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                DEFINITION_DESCRIPTOR.index -> builder.definition = deserializeString()
                LABEL_DESCRIPTOR.index -> builder.label = deserializeString()
                LOGGINGCONFIGURATION_DESCRIPTOR.index -> builder.loggingConfiguration = deserializeLoggingConfigurationDocument(deserializer)
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                ROLEARN_DESCRIPTOR.index -> builder.roleArn = deserializeString()
                STATEMACHINEARN_DESCRIPTOR.index -> builder.stateMachineArn = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { StateMachineStatus.fromValue(it) }
                TRACINGCONFIGURATION_DESCRIPTOR.index -> builder.tracingConfiguration = deserializeTracingConfigurationDocument(deserializer)
                TYPE_DESCRIPTOR.index -> builder.type = deserializeString().let { StateMachineType.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
