// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sfn.transform

import aws.sdk.kotlin.services.sfn.model.ListMapRunsResponse
import aws.sdk.kotlin.services.sfn.model.MapRunListItem
import aws.sdk.kotlin.services.sfn.model.SfnException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ListMapRunsOperationDeserializer: HttpDeserialize<ListMapRunsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListMapRunsResponse {
        if (!response.status.isSuccess()) {
            throwListMapRunsError(context, response)
        }
        val builder = ListMapRunsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListMapRunsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListMapRunsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SfnException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ExecutionDoesNotExist" -> ExecutionDoesNotExistDeserializer().deserialize(context, wrappedResponse)
        "InvalidArn" -> InvalidArnDeserializer().deserialize(context, wrappedResponse)
        "InvalidToken" -> InvalidTokenDeserializer().deserialize(context, wrappedResponse)
        else -> SfnException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListMapRunsOperationBody(builder: ListMapRunsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val MAPRUNS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("mapRuns"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(MAPRUNS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                MAPRUNS_DESCRIPTOR.index -> builder.mapRuns =
                    deserializer.deserializeList(MAPRUNS_DESCRIPTOR) {
                        val col0 = mutableListOf<MapRunListItem>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeMapRunListItemDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
