// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sfn.transform

import aws.sdk.kotlin.services.sfn.model.SendTaskSuccessResponse
import aws.sdk.kotlin.services.sfn.model.SfnException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class SendTaskSuccessOperationDeserializer: HttpDeserialize<SendTaskSuccessResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): SendTaskSuccessResponse {
        if (!response.status.isSuccess()) {
            throwSendTaskSuccessError(context, response)
        }
        val builder = SendTaskSuccessResponse.Builder()

        return builder.build()
    }
}

private suspend fun throwSendTaskSuccessError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SfnException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidOutput" -> InvalidOutputDeserializer().deserialize(context, wrappedResponse)
        "InvalidToken" -> InvalidTokenDeserializer().deserialize(context, wrappedResponse)
        "TaskDoesNotExist" -> TaskDoesNotExistDeserializer().deserialize(context, wrappedResponse)
        "TaskTimedOut" -> TaskTimedOutDeserializer().deserialize(context, wrappedResponse)
        else -> SfnException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
